% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CMBDataFrameGenerics.R
\name{ordering.CMBDataFrame}
\alias{ordering.CMBDataFrame}
\title{HEALPix ordering scheme from a CMBDataFrame}
\usage{
\method{ordering}{CMBDataFrame}(x, new.ordering, ...)
}
\arguments{
\item{x}{A \code{\link{CMBDataFrame}}.}

\item{new.ordering}{Specifies the new ordering ("ring" or "nest")
if a change of ordering
scheme is desired.}

\item{...}{Unused arguments.}
}
\value{
The name of the HEALPix ordering scheme that is
used in the CMBDataFrame x.
}
\description{
This function returns the HEALPix ordering scheme from a CMBDataFrame.
The ordering scheme is either "ring" or "nested".
}
\details{
If a new ordering is specified, using e.g. new.ordering = "ring", the
ordering scheme of the CMBDataFrame will be converted.
}
\examples{
df <- CMBDataFrame(nside = 1, ordering = "nested")
ordering(df)
df1 <- ordering(df, new.ordering = "ring")
ordering(df1)

}
