% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Statistics.R
\name{exprob}
\alias{exprob}
\title{Threshold exceedance probability}
\usage{
exprob(cmbdf, win, alpha, intensities = "I")
}
\arguments{
\item{cmbdf}{A \code{\link{CMBDataFrame}}.}

\item{win}{A \code{\link{CMBWindow}}}

\item{alpha}{A numeric threshold level.}

\item{intensities}{The name of the column in \code{cmbdf}
that contains the measured values.}
}
\value{
Estimated threshold exceedance probability
}
\description{
This function returns an estimated exceedance probability for the specified
\code{\link{CMBDataFrame}} column  \code{intensities}, threshold level
\eqn{alpha} and \code{\link{CMBWindow}} region.
}
\examples{
## Download the map first
# downloadCMBMap(foreground = "smica", nside = 1024)
# df <- CMBDataFrame("CMB_map_smica1024.fits")
# cmbdf <- sampleCMB(df, sample.size = 1000)

# intensities <- "I"
# alpha <- mean(cmbdf[,intensities, drop = TRUE])
# alpha

# win1 <- CMBWindow(theta = c(0,pi/2,pi/2), phi = c(0,0,pi/2))
# exprob(cmbdf, win1, alpha)

}
