% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdb_series.R
\name{rdb_series}
\alias{rdb_series}
\title{Download list of series for datasets of DBnomics providers.}
\usage{
rdb_series(
  provider_code = NULL,
  dataset_code = NULL,
  use_readLines = getOption("rdbnomics.use_readLines"),
  curl_config = getOption("rdbnomics.curl_config"),
  simplify = FALSE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{provider_code}{Character string (default \code{NULL}). DBnomics code
of one or multiple providers. If \code{NULL}, the providers are firstly
dowloaded with the function \code{\link{rdb_providers}} and then the
datasets are requested.}

\item{dataset_code}{Character string (default \code{NULL}). DBnomics code
of one or multiple datasets of a provider. If \code{NULL}, the datasets
codes are dowloaded with the function \code{\link{rdb_datasets}} and then
the series are requested.}

\item{use_readLines}{Logical (default \code{FALSE}). If \code{TRUE}, then
the data are requested and read with the base function \code{readLines} i.e.
through the default R internet connection. This can be used to get round the
error \code{Could not resolve host: api.db.nomics.world}.}

\item{curl_config}{Named list (default \code{NULL}). If not
\code{NULL}, it is used to configure a proxy connection. This
configuration is passed to the function \code{curl_fetch_memory} of the package
\pkg{curl}. A temporary \code{curl_handle} object is created internally
with arguments equal to the provided list in \code{curl_config}.\cr
For \code{curl_fetch_memory} arguments see \code{\link[curl]{curl_fetch}}.
For available curl options see \code{\link[curl]{curl_options}},
\code{names(curl_options())} and
\href{https://curl.haxx.se/libcurl/c/curl_easy_setopt.html}{libcurl}.}

\item{simplify}{Logical (default \code{FALSE}). If \code{TRUE}, when the
series are requested for only one provider and one dataset then a
\code{data.table} is returned, not a nested named list of
\code{data.table}s.}

\item{verbose}{Logical (default \code{FALSE}). Show number of series per
datasets and providers.}

\item{...}{Additionals arguments.}
}
\value{
A nested named list of \code{data.table}s or a \code{data.table}.
}
\description{
\code{rdb_series} downloads the list of series for
available datasets of a selection of providers from
\href{https://db.nomics.world/}{DBnomics}. \cr
/!\ We warn the user that this function can be (very) long to execute. We remind
that DBnomics requests data from 63 providers to retrieve 21675 datasets for
a total of approximately 720 millions series.
}
\details{
By default, the function returns a nested named list of \code{data.table}s
containing the series of datasets for providers from
\href{https://db.nomics.world/}{DBnomics}.
}
\examples{
\dontrun{
rdb_series(provider_code = "IMF", dataset_code = "WEO")

rdb_series(provider_code = "IMF", dataset_code = "WEO", simplify = TRUE)

rdb_series(provider_code = "IMF", verbose = TRUE)

options(rdbnomics.progress_bar_series = TRUE)
rdb_series(provider_code = "IMF", dataset_code = "WEO")
options(rdbnomics.progress_bar_series = FALSE)

rdb_series(
  provider_code = "IMF", dataset_code = "WEO",
  use_readLines = TRUE
)

rdb_series(
  provider_code = "IMF", dataset_code = "WEO",
  curl_config = list(proxy = "<proxy>", proxyport = <port>)
)
}
}
\seealso{
\code{\link{rdb_providers}}, \code{\link{rdb_last_updates}},
\code{\link{rdb_datasets}}, \code{\link{rdb_dimensions}}
}
\author{
Sebastien Galais
}
