% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbnomics.R
\name{dbnomics}
\alias{dbnomics}
\title{DBnomics ggplot2 theme}
\usage{
dbnomics(color_palette = "Set1", ...)
}
\arguments{
\item{color_palette}{Character string (default \code{"Set1"}) to change the
default color palette. If you want to use the default palette, set it to
\code{NULL}.}

\item{...}{Arguments to be passed to the function \code{ggplot2::theme}.}
}
\description{
\code{dbnomics} is a simple ggplot2 theme for drawing nicer graphics. We do not
recommend to use it. It has been included in the package to avoid errors
when reproducing the vignette examples.
}
\examples{
\dontrun{
library(magrittr)
library(ggplot2)

rdb("IMF", "WEO", query = "France current account balance percent") \%>\%
  ggplot(aes(x = period, y = value, color = series_name)) +
  geom_line(size = 1.2) +
  geom_point(size = 2) +
  dbnomics()
}
}
\author{
Sebastien Galais
}
