% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrd_sens_bw.R
\name{mrd_sens_bw}
\alias{mrd_sens_bw}
\title{Bandwidth Sensitivity Simulation for Multivariate Regression Discontinuity}
\usage{
mrd_sens_bw(object, approach = c("center", "univ1", "univ2"), bws)
}
\arguments{
\item{object}{An object returned by \code{mrd_est} or \code{mrd_impute}.}

\item{approach}{A string of the approaches to be refitted, 
choosing from \code{c("center", "univ1", "univ2")}.}

\item{bws}{A positive numeric vector of bandwidth for refitting an \code{mrd} object.}
}
\value{
A dataframe which contains the estimate \code{est} and standard error \code{se} 
  for each supplemented bandwidth.
}
\description{
\code{mrd_sens_bw} refits the supplemented model with varying bandwidth. 
Other estimation parameters are held constant.
}
\examples{
x1 <- runif(1000, -1, 1)
x2 <- rnorm(1000, 10, 2)
cov <- rnorm(1000)
y <- 3 + 2 * x1 + 1 * x2 + 3 * cov + 10 * (x1 >= 0) + 5 * (x2 >= 10) + rnorm(1000)
mrd <- mrd_est(y ~ x1 + x2 | cov, cutpoint = c(0, 10))
mrd_sens_bw(mrd, approach = "univ1", bws = seq(0.1, 1, length.out = 5))
}
