% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rd_est.R
\name{rd_est}
\alias{rd_est}
\title{Regression Discontinuity Estimation}
\usage{
rd_est(
  formula,
  data,
  subset = NULL,
  cutpoint = NULL,
  bw = NULL,
  kernel = "triangular",
  se.type = "HC1",
  cluster = NULL,
  verbose = FALSE,
  less = FALSE,
  est.cov = FALSE,
  est.itt = FALSE,
  t.design = NULL
)
}
\arguments{
\item{formula}{The formula of the RDD. This is supplied in the
format of \code{y ~ x} for a simple sharp RDD, or \code{y ~ x | c1 + c2}
for a sharp RDD with two covariates. Fuzzy RDD may be specified as
\code{y ~ x + z} where \code{x} is the running variable, and 
\code{z} is the endogenous treatment variable. Covariates are then included in the 
same manner as in a sharp RDD.}

\item{data}{An optional data frame.}

\item{subset}{An optional vector specifying a subset of observations to be used}

\item{cutpoint}{The cutpoint. If omitted, it is assumed to be 0.}

\item{bw}{A numeric vector specifying the bandwidths at which to estimate the RD. 
If omitted or it is \code{"IK12"}, the bandwidth is calculated using the Imbens-Kalyanaraman 
2012 method. If it is \code{"IK09"}, the bandwidth is calculated using 
the Imbens-Kalyanaraman 2009 method. Then it is estimated
with that bandwidth, half that bandwidth, and twice that bandwidth.  
If only a single value is passed into the function,
the RD will similarly be estimated at that bandwidth, half that bandwidth, 
and twice that bandwidth.}

\item{kernel}{A string specifying the kernel to be used in the local linear fitting. 
\code{"triangular"} kernel is the default and is the "correct" theoretical kernel to be 
used for edge estimation as in RDD (Lee and Lemieux, 2010). Other options are 
\code{"rectangular"}, \code{"epanechnikov"}, \code{"quartic"}, 
\code{"triweight"}, \code{"tricube"}, \code{"gaussian"} and \code{"cosine"}.}

\item{se.type}{This specifies the robust SE calculation method to use. Options are,
as in \code{\link{vcovHC}}, \code{"HC3"}, \code{"const"}, \code{"HC"}, \code{"HC0"}, 
\code{"HC1"}, \code{"HC2"}, \code{"HC4"}, \code{"HC4m"}, \code{"HC5"}. This option 
is overridden by \code{cluster}.}

\item{cluster}{An optional vector specifying clusters within which the errors are assumed
to be correlated. This will result in reporting cluster robust SEs. This option overrides
anything specified in \code{se.type}. It is suggested that data with a discrete running 
variable be clustered by each unique value of the running variable (Lee and Card, 2008).}

\item{verbose}{Will provide some additional information printed to the terminal.}

\item{less}{Logical. If \code{TRUE}, return the estimates of linear and optimal, 
instead of linear, quadratic, cubic, optimal, half and double.}

\item{est.cov}{Logical. If \code{TRUE}, the estimates of covariates will be included.}

\item{est.itt}{Logical. If \code{TRUE}, the estimates of ITT will be returned.}

\item{t.design}{The treatment option according to design.
The entry is for X: \code{"g"} means treatment is assigned 
if X is greater than its cutoff, \code{"geq"} means treatment is assigned 
if X is greater than or equal to its cutoff, \code{"l"} means treatment is assigned 
if X is less than its cutoff, \code{"leq"} means treatment is assigned 
if X is less than or equal to its cutoff.}
}
\value{
\code{rd_est} returns an object of \link{class} "\code{rd}".
  The functions \code{summary} and \code{plot} are used to obtain and print a summary and 
  plot of the estimated regression discontinuity. The object of class \code{rd} is a list 
  containing the following components:
\item{type}{A string denoting either \code{"sharp"} or \code{"fuzzy"} RDD.}
\item{est}{Numeric vector of the estimate of the discontinuity in the outcome under 
  a sharp design, or the Wald estimator in the fuzzy design for each corresponding bandwidth.}
\item{se}{Numeric vector of the standard error for each corresponding bandwidth.}
\item{z}{Numeric vector of the z statistic for each corresponding bandwidth.}
\item{p}{Numeric vector of the p value for each corresponding bandwidth.}
\item{ci}{The matrix of the 95% confidence interval, \code{c("CI Lower Bound", "CI Upper Bound")} 
  for each corresponding bandwidth.}
\item{d}{Numeric vector of the effective size (Cohen's d) for each estimate.}
\item{cov}{The names of covariates.}
\item{bw}{Numeric vector of each bandwidth used in estimation.}
\item{obs}{Vector of the number of observations within the corresponding bandwidth.}
\item{call}{The matched call.}
\item{na.action}{The observations removed from fitting due to missingness.}
\item{impute}{Whether multiple imputation is used or not.}
\item{model}{For a sharp design, a list of the \code{lm} objects is returned.
  For a fuzzy design, a list of lists is returned, each with two elements: 
  \code{firststage}, the first stage \code{lm} object, and \code{iv}, the \code{ivreg} object. 
  A model is returned for each corresponding bandwidth.}
\item{frame}{Returns the model frame used in fitting.}
}
\description{
\code{rd_est} estimates both sharp and fuzzy RDD, using parametric and non-parametric 
(local linear) models. 
It is based on the \code{\link[rdd]{RDestimate}} function in the \pkg{rdd} package.
Sharp RDDs (both parametric and non-parametric) are estimated using \code{lm} in the 
\pkg{stats} package.
Fuzzy RDDs (both parametric and non-parametric) are estimated using two-stage least-squares 
\code{ivreg} in the \pkg{AER} package. 
For non-parametric models, Imbens-Kalyanaraman optimal bandwidths can be used,
}
\examples{
x <- runif(1000, -1, 1)
cov <- rnorm(1000)
y <- 3 + 2 * x + 3 * cov + 10 * (x >= 0) + rnorm(1000)
rd_est(y ~ x, t.design = "geq")
# Efficiency gains can be made by including covariates
rd_est(y ~ x | cov, t.design = "geq")
}
\references{
Lee, D. S., Lemieux, T. (2010).
  Regression Discontinuity Designs in Economics.
  Journal of Economic Literature, 48(2), 281-355. 
  \url{http://www.aeaweb.org/articles.php?doi=10.1257/jel.48.2.281}.

Imbens, G., Lemieux, T. (2008).
  Regression discontinuity designs: A guide to practice.
  Journal of Econometrics, 142(2), 615-635. 
  \url{http://dx.doi.org/10.1016/j.jeconom.2007.05.001}.

Lee, D. S., Card, D. (2010).
  Regression discontinuity inference with specification error. 
  Journal of Econometrics, 142(2), 655-674. 
  \url{http://dx.doi.org/10.1016/j.jeconom.2007.05.003}.

Angrist, J. D., Pischke, J.-S. (2009). 
  Mostly harmless econometrics: An empiricist's companion. 
  Princeton, NJ: Princeton University Press.
}
