% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui.R
\name{get_variable_labels}
\alias{get_variable_labels}
\title{Get Survey Variable Labels}
\usage{
get_variable_labels(dataset, return_all = TRUE)
}
\arguments{
\item{dataset}{Can be either the file path to a dataset, the dataset as a
`data.frame` or the filenames of datasets. See details for more information}

\item{return_all}{Logical whether to return all variables (\code{TRUE})
or only those with labels.}
}
\value{
A \code{data.frame} consisting of the variable name and labels.
}
\description{
Return variable labels from a dataset
}
\details{
Returns variable names and their labels from a dataset.
  You can pass for the `data` argument any of
  the following:
  \itemize{
      \item The file path to a saved dataset. This would be the direct
      output of \code{\link{get_datasets}}
      \item A read in dataset, i.e. produced by using \code{\link{readRDS}}
      to load a dataset from
      a file path produced by \code{\link{get_datasets}}
      \item Dataset filenames. These can be found as one of the returned
      fields from \code{\link{dhs_datasets}}. If these datasets have not been
      downloaded before this will download them for you.
      }
}
\examples{
\dontrun{
# get the model datasets included with the package
model_datasets <- model_datasets

# download one of them
g <- get_datasets(dataset_filenames = model_datasets$FileName[1])

# we can pass the list of filepaths to the function
head(get_variable_labels(g))

# or we can pass the full dataset
r <- readRDS(g[[1]])
head(get_variable_labels(r))
}
}
