% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdrbounds.R
\name{rdrbounds}
\alias{rdrbounds}
\title{Rosenbaum bounds for RD designs under local randomization}
\usage{
rdrbounds(
  Y,
  R,
  cutoff = 0,
  wlist,
  gamma,
  expgamma,
  bound = "both",
  statistic = "ranksum",
  p = 0,
  evalat = "cutoff",
  kernel = "uniform",
  fuzzy = NULL,
  nulltau = 0,
  prob,
  fmpval = FALSE,
  reps = 1000,
  seed = 666
)
}
\arguments{
\item{Y}{a vector containing the values of the outcome variable.}

\item{R}{a vector containing the values of the running variable.}

\item{cutoff}{the RD cutoff (default is 0).}

\item{wlist}{the list of window lengths to be evaluated. By default the program constructs 10 windows around the cutoff, the first one including 10 treated and control observations and adding 5 observations to each group in subsequent windows.}

\item{gamma}{the list of values of gamma to be evaluated.}

\item{expgamma}{the list of values of exp(gamma) to be evaluated. Default is \code{c(1.5,2,2.5,3)}.}

\item{bound}{specifies which bounds the command calculates. Options are \code{upper} for upper bound, \code{lower} for lower bound and \code{both} for both upper and lower bounds. Default is \code{both}.}

\item{statistic}{the statistic to be used in the balance tests. Allowed options are \code{diffmeans} (difference in means statistic), \code{ksmirnov} (Kolmogorov-Smirnov statistic) and \code{ranksum} (Wilcoxon-Mann-Whitney standardized statistic). Default option is \code{diffmeans}. The statistic \code{ttest} is equivalent to \code{diffmeans} and included for backward compatibility.}

\item{p}{the order of the polynomial for outcome adjustment model. Default is 0.}

\item{evalat}{specifies the point at which the adjusted variable is evaluated. Allowed options are \code{cutoff} and \code{means}. Default is \code{cutoff}.}

\item{kernel}{specifies the type of kernel to use as weighting scheme. Allowed kernel types are \code{uniform} (uniform kernel), \code{triangular} (triangular kernel) and \code{epan} (Epanechnikov kernel). Default is \code{uniform}.}

\item{fuzzy}{indicates that the RD design is fuzzy. \code{fuzzy} can be specified as a vector containing the values of the endogenous treatment variable, or as a list where the first element is the vector of endogenous treatment values and the second element is a string containing the name of the statistic to be used. Allowed statistics are \code{ar} (Anderson-Rubin statistic) and \code{tsls} (2SLS statistic). Default statistic is \code{ar}. The \code{tsls} statistic relies on large-sample approximation.}

\item{nulltau}{the value of the treatment effect under the null hypothesis. Default is 0.}

\item{prob}{the probabilities of treatment for each unit when assignment mechanism is a Bernoulli trial. This option should be specified as a vector of length equal to the length of the outcome and running variables.}

\item{fmpval}{reports the p-value under fixed margins randomization, in addition to the p-value under Bernoulli trials.}

\item{reps}{number of replications. Default is 1000.}

\item{seed}{the seed to be used for the randomization tests.}
}
\value{
\item{gamma}{list of gamma values.}
\item{expgamma}{list of exp(gamma) values.}
\item{wlist}{window grid.}
\item{p.values}{p-values for each window (under gamma = 0).}
\item{lower.bound}{list of lower bound p-values for each window and gamma pair.}
\item{upper.bound}{list of upper bound p-values for each window and gamma pair.}
}
\description{
\code{rdrbounds} calculates lower and upper bounds for the
 randomization p-value under different degrees of departure from a
 local randomized experiment, as suggested by Rosenbaum (2002).
}
\examples{
# Toy dataset
R <- runif(100,-1,1)
Y <- 1 + R -.5*R^2 + .3*R^3 + (R>=0) + rnorm(100)
# Rosenbaum bounds
# Note: low number of replications and windows to speed up process.
# The user should increase these values.
rdrbounds(Y,R,expgamma=c(1.5,2),wlist=c(.3),reps=100)


}
\references{
M.D. Cattaneo, B. Frandsen and R. Titiunik. (2015).  \href{https://sites.google.com/site/rdpackages/rdlocrand/Cattaneo-Frandsen-Titiunik_2015_JCI.pdf}{Randomization Inference in the Regression Discontinuity Design: An Application to Party Advantages in the U.S. Senate}. \emph{Journal of Causal Inference} 3(1): 1-24.

M.D. Cattaneo, R. Titiunik and G. Vazquez-Bare. (2016). \href{https://sites.google.com/site/rdpackages/rdlocrand/Cattaneo-Titiunik-VazquezBare_2016_Stata.pdf}{Inference in Regression Discontinuity Designs under Local Randomization}. \emph{Stata Journal} 16(2): 331-367.

M.D. Cattaneo, R. Titiunik and G. Vazquez-Bare. (2017). \href{https://sites.google.com/site/rdpackages/rdlocrand/Cattaneo-Titiunik-VazquezBare_2017_JPAM.pdf}{Comparing Inference Approaches for RD Designs: A Reexamination of the Effect of Head Start on Child Mortality}. \emph{Journal of Policy Analysis and Management} 36(3): 643-681.

P. Rosenbaum (2002). Observational Studies. Springer.
}
\author{
Matias Cattaneo, Princeton University. \email{cattaneo@princeton.edu}

Rocio Titiunik, Princeton University. \email{titiunik@princeton.edu}

Gonzalo Vazquez-Bare, UC Santa Barbara. \email{gvazquez@econ.ucsb.edu}
}
