% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdoc.R
\name{rdoc_question}
\alias{rdoc_question}
\title{Colourised \R documentation}
\usage{
rdoc_question(type, topic)
}
\arguments{
\item{type}{the special type of documentation to use for this topic;
    for example, if the type is \code{class}, documentation is
    provided for the class with name \code{topic}.
    See the Section \sQuote{S4 Method Documentation} for the uses of
    \code{type} to get help on formal methods, including
    \code{methods?\var{function}} and \code{method?\var{call}}.
  }

\item{topic}{Usually, a \link{name} or character string specifying the
    topic for which help is sought.

    Alternatively, a function call to ask for documentation on a
    corresponding S4 method: see the section on S4 method documentation.
    The calls \code{\var{pkg}::\var{topic}} and
    \code{\var{pkg}:::\var{topic}} are treated specially, and look for
    help on \code{topic} in package \pkg{\var{pkg}}.
  }
}
\description{
Refer to colourised \R docs as terminal output. Provides a
replacement for \code{?}. Meant primarily for use as an
override in \code{use_rdoc()}
}
\details{
The manner in which content is outputted depends on where it is
  being used. If used from a terminal the contents will be outputted via
  \code{file.show}. Otherwise the output will be printed interactively by
  sections unless this has been disabled via \code{options(rdoc.by_section =
  FALSE)}. When printing by section pressing the <enter> keypress will show
  the next section. Any other keypress will exit the interaction without
  printing any remaining sections. Color support is checked via
  \code{crayon::has_color()}. Customising rdoc output is possible via
  `options`, see \code{\link{rdoc_options}} for more details.
}
\examples{
\donttest{

rdoc::rdoc_question('lapply')

}
}
