\name{as.data.frame.ABF}
\alias{as.data.frame.ABF}
\title{Coerces an ABF Object to a Data Frame}

\description{
S3 method to coerce an \code{\link[=readABF]{ABF}} object to a data frame.
}

\usage{
\S3method{as.data.frame}{ABF}(x, row.names = NULL, optional = FALSE, ..., sweep = NULL,
type = c("all", "one"), channels, unit = NULL)
}

\arguments{
  \item{x}{an object of class ABF, typically generated by \code{\link{readABF}}.}
  \item{row.names, optional, ...}{further arguments in case they are passed from other methods; they will be ignored.}
  \item{sweep}{an integer, indicating which sweep should be coerced; required in case of multiple sweeps, otherwise ignored.}
  \item{type}{a string specifying the return value, see \sQuote{Value}.}
  \item{channels}{an integer vector of length one or two; required if \code{type == "one"}, otherwise ignored, see \sQuote{Value}.}
  \item{unit}{a string, specifying the unit of one, if \code{NULL} unit will be determined by units in \code{x};
  ignored if \code{type == "all"} or \code{length(channels) == 1}}
}

\value{A \code{data.frame}. The first column always contains the time which is calculated from the sampling interval.
The earliest data point is believed to be at time 0.

Column names are accompanied by their units.

If \code{type == "all"}, all channels are added to the resulting data frame. Their units are copied from the ABF object.

If \code{type == "one"}, the resulting data frame only contains the time (see above) and one additional column with the actual data, whereby \code{channels}, a vector of integers, specifies what to read. If \code{channels} contains one index, then that channel is used for the data column. If \code{channels} contains two indices, then the data of the first channel is divided by the data of the second channel. This might be for instance helpful to obtain conductance by dividing a channel containing current values by a channel containing voltage values. The unit of the data column is either provided by \code{unit} or, if not provided, the ratio of the two units (as read from the ABF object) is given.
}

\examples{
# loads an example file and coerces its first sweep to data frame
r <- readABF(system.file("extdata", "2009_01_19_0002_varlen_v18.abf", package="readABF"))
as.data.frame(r, sweep=1)
}
