% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_dhis2-helpers.R
\name{get_program_org_units}
\alias{get_program_org_units}
\title{Get organisation units that are associated with a given program}
\usage{
get_program_org_units(login, program, org_units = NULL)
}
\arguments{
\item{login}{A httr2_response object returned by the \code{dhis2_login()} function}

\item{program}{A character with the program ID or name}

\item{org_units}{A data frame with all organisation units from target DHIS2
instance. This is the output from the \code{get_organisation_units()} function}
}
\value{
A data frame with the organisation units associated with the
provided program
}
\description{
Get organisation units that are associated with a given program
}
\examples{
\dontrun{
  # login to the DHIS2 instance
  dhis2_login <- login(
    type = "dhis2",
    from = "https://smc.moh.gm/dhis",
    user_name = "test",
    password = "Gambia@123"
  )

  # fetch the organisation units
  org_units <- get_organisation_units(login = dhis2_login)

  # get the organisation units associated with the following program
  'E5IUQuHg3Mg'
  target_org_units <- get_program_org_units(
    login = dhis2_login,
    program = "E5IUQuHg3Mg",
    org_units = org_units
  )
}
}
