% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_dhis2-helpers.R
\name{get_programs}
\alias{get_programs}
\title{get all programs from a given specific DHIS2 instance}
\usage{
get_programs(login)
}
\arguments{
\item{login}{A httr2_response object returned by the \code{dhis2_login()} function}
}
\value{
A data frame with the following columns: the program ID, the program
name, and the program type specifying whether the program is part of the
Aggregate or Tracker system.
}
\description{
The function first fetches all programs from the DHIS2 Aggregate system,
then distinguishes the Tracker and Aggregate programs.
}
\examples{
\dontrun{
  # establish the connection to the system
  dhis2_login <- login(
    type = "dhis2",
    from = "https://smc.moh.gm/dhis",
    user_name = "test",
    password = "Gambia@123"
  )

  # fetch the programs
  programs <- get_programs(login = dhis2_login)
}

}
