% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/centering.R
\name{center_min}
\alias{center_min}
\title{Centers the lowest value with values increasing around it}
\usage{
center_min(data, col = NULL, shuffle_sides = FALSE)
}
\arguments{
\item{data}{\code{data.frame} or \code{vector}.}

\item{col}{Column to create sorting factor by. When \code{NULL} and \code{`data`} is a \code{data.frame},
the row numbers are used.}

\item{shuffle_sides}{Whether to shuffle which elements are left and right of the center. (Logical)}
}
\value{
The sorted \code{data.frame} (\code{tibble}) / \code{vector}.
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("experimental")}

The lowest value is positioned in the middle with the other
values increasing around it.

\strong{Example}:

The column values:

\code{c(}\strong{\code{1}}\code{, 2, 3, 4, 5)}

are \strong{ordered as}:

\code{c(5, 3,} \strong{\code{1}}\code{, 2, 4)}
}
\examples{
# Attach packages
library(rearrr)
library(dplyr)

# Set seed
set.seed(1)

# Create a data frame
df <- data.frame(
  "index" = 1:10,
  "A" = sample(1:10),
  "B" = runif(10),
  "C" = LETTERS[1:10],
  "G" = c(
    1, 1, 1, 2, 2,
    2, 3, 3, 3, 3
  ),
  stringsAsFactors = FALSE
)

# Center by the index (row numbers)
center_min(df)

# Center by each of the columns
center_min(df, col = "A")
center_min(df, col = "B")
center_min(df, col = "C")

# Randomize which elements are left and right of the center
center_min(df, col = "A", shuffle_sides = TRUE)

# Grouped by G
df \%>\%
  dplyr::select(G, A) \%>\% # For clarity
  dplyr::group_by(G) \%>\%
  center_min(col = "A")

# Plot the centered values
plot(x = 1:10, y = center_min(df, col = "B")$B)
plot(x = 1:10, y = center_min(df, col = "B", shuffle_sides = TRUE)$B)
}
\seealso{
Other rearrange functions: 
\code{\link{center_max}()},
\code{\link{closest_to}()},
\code{\link{furthest_from}()},
\code{\link{pair_extremes}()},
\code{\link{position_max}()},
\code{\link{position_min}()},
\code{\link{rev_windows}()},
\code{\link{roll_elements}()}
}
\author{
Ludvig Renbo Olsen, \email{r-pkgs@ludvigolsen.dk}
}
\concept{rearrange functions}
