library(rearrr)
context("angle()")

test_that("angle() works", {
  # Set seed
  xpectr::set_test_seed(42)

  df <- data.frame(
    "x" = runif(20),
    "y" = runif(20),
    "g" = rep(1:4, each = 5),
    stringsAsFactors = FALSE
  )


  ## Testing 'angle( data = df, x_col = "x", y_col = "y", ...'              ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_13795 <- angle(
      data = df,
      x_col = "x",
      y_col = "y",
      origin = c(0.5, 0.5)
    )
  # Testing class
  expect_equal(
    class(output_13795),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_13795[["x"]],
    c(0.91481, 0.93708, 0.28614, 0.83045, 0.64175, 0.5191, 0.73659,
      0.13467, 0.65699, 0.70506, 0.45774, 0.71911, 0.93467, 0.25543,
      0.46229, 0.94001, 0.97823, 0.11749, 0.475, 0.56033),
    tolerance = 1e-4)
  expect_equal(
    output_13795[["y"]],
    c(0.90403, 0.13871, 0.98889, 0.94667, 0.08244, 0.51421, 0.3902,
      0.90574, 0.44697, 0.836, 0.7376, 0.81106, 0.38811, 0.68517,
      0.00395, 0.83292, 0.00733, 0.20766, 0.9066, 0.61178),
    tolerance = 1e-4)
  expect_equal(
    output_13795[["g"]],
    c(1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4),
    tolerance = 1e-4)
  expect_equal(
    output_13795[[".degrees"]],
    c(44.24612, 320.42261, 113.62646, 53.50576, 288.75027, 36.65774,
      335.1048, 132.0004, 341.33556, 58.60411, 100.08504, 54.83852,
      345.56453, 142.86991, 265.65304, 37.11124, 314.14794, 217.38941,
      93.51883, 61.64196),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_13795),
    c("x", "y", "g", ".degrees", ".origin"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_13795),
    c("numeric", "numeric", "integer", "numeric", "list"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_13795),
    c("double", "double", "integer", "double", "list"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_13795),
    c(20L, 5L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_13795)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'angle( data = df, x_col = "x", y_col = "y", ...'     ####


})

test_that("fuzz testing angle()", {
  xpectr::set_test_seed(42)

  df <- data.frame(
    "x" = runif(20),
    "y" = runif(20),
    "g" = rep(1:4, each = 5),
    stringsAsFactors = FALSE
  )

  # Generate expectations for 'angle'
  # Tip: comment out the gxs_function() call
  # so it is easy to regenerate the tests
  xpectr::set_test_seed(42)
  # xpectr::gxs_function(
  #   fn = angle,
  #   args_values = list(
  #     "data" = list(df, dplyr::group_by(df, g), c(1,2,3,4,5,6)),
  #     "x_col" = list("x", "hej", 1, NA),
  #     "y_col" = list("y", "x", "hej", 1, NA),
  #     "origin" = list(c(0, 0), c(0, 0, 0), c(NA, NA), c(1, 1), NA),
  #     "origin_fn" = list(NULL, centroid, most_centered),
  #     "degrees_col_name" = list(".degrees", ".gredees", NA),
  #     "origin_col_name" = list(".origin", ".oruguay",  NA),
  #     "overwrite" = list(FALSE)
  #   ),
  #   extra_combinations = list(
  #     list("data" = dplyr::group_by(df, g), "origin_fn" = centroid),
  #     list("data" = c(1,2,3,4,5), "x_col" = NULL, "y_col" = NULL, "origin_fn" = centroid, "origin" = NULL),
  #     list("overwrite" = FALSE, "origin_col_name" = "x"),
  #     list("overwrite" = FALSE, "origin_col_name" = "g"),
  #     list("overwrite" = TRUE, "origin_col_name" = "x")
  #   ),
  #   indentation = 2,
  #   copy_env = FALSE
  # )


  ## Testing 'angle'                                                          ####
  ## Initially generated by xpectr
  # Testing different combinations of argument values

  # Testing angle(data = df, x_col = "x", y_col = "y", o...
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- angle(data = df, x_col = "x", y_col = "y", origin = c(0, 0), origin_fn = NULL, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = FALSE)
  # Testing class
  expect_equal(
    class(output_19148),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19148[["x"]],
    c(0.91481, 0.93708, 0.28614, 0.83045, 0.64175, 0.5191, 0.73659,
      0.13467, 0.65699, 0.70506, 0.45774, 0.71911, 0.93467, 0.25543,
      0.46229, 0.94001, 0.97823, 0.11749, 0.475, 0.56033),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["y"]],
    c(0.90403, 0.13871, 0.98889, 0.94667, 0.08244, 0.51421, 0.3902,
      0.90574, 0.44697, 0.836, 0.7376, 0.81106, 0.38811, 0.68517,
      0.00395, 0.83292, 0.00733, 0.20766, 0.9066, 0.61178),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["g"]],
    c(1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4),
    tolerance = 1e-4)
  expect_equal(
    output_19148[[".degrees"]],
    c(44.66059, 8.42004, 73.862, 48.74173, 7.32003, 44.72918, 27.91215,
      81.54313, 34.22851, 49.85657, 58.17683, 48.43859, 22.54992,
      69.55472, 0.48934, 41.5431, 0.42956, 60.50009, 62.34854, 47.51319),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19148),
    c("x", "y", "g", ".degrees", ".origin"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19148),
    c("numeric", "numeric", "integer", "numeric", "list"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19148),
    c("double", "double", "integer", "double", "list"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19148),
    c(20L, 5L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19148)),
    character(0),
    fixed = TRUE)

  # Testing angle(data = dplyr::group_by(df, g), x_col =...
  # Changed from baseline: data = dplyr::group_b...
  xpectr::set_test_seed(42)
  # Assigning output
  output_19370 <- angle(data = dplyr::group_by(df, g), x_col = "x", y_col = "y", origin = c(0, 0), origin_fn = NULL, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = FALSE)
  # Testing class
  expect_equal(
    class(output_19370),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19370[["x"]],
    c(0.91481, 0.93708, 0.28614, 0.83045, 0.64175, 0.5191, 0.73659,
      0.13467, 0.65699, 0.70506, 0.45774, 0.71911, 0.93467, 0.25543,
      0.46229, 0.94001, 0.97823, 0.11749, 0.475, 0.56033),
    tolerance = 1e-4)
  expect_equal(
    output_19370[["y"]],
    c(0.90403, 0.13871, 0.98889, 0.94667, 0.08244, 0.51421, 0.3902,
      0.90574, 0.44697, 0.836, 0.7376, 0.81106, 0.38811, 0.68517,
      0.00395, 0.83292, 0.00733, 0.20766, 0.9066, 0.61178),
    tolerance = 1e-4)
  expect_equal(
    output_19370[["g"]],
    c(1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4),
    tolerance = 1e-4)
  expect_equal(
    output_19370[[".degrees"]],
    c(44.66059, 8.42004, 73.862, 48.74173, 7.32003, 44.72918, 27.91215,
      81.54313, 34.22851, 49.85657, 58.17683, 48.43859, 22.54992,
      69.55472, 0.48934, 41.5431, 0.42956, 60.50009, 62.34854, 47.51319),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19370),
    c("x", "y", "g", ".degrees", ".origin"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19370),
    c("numeric", "numeric", "integer", "numeric", "list"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19370),
    c("double", "double", "integer", "double", "list"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19370),
    c(20L, 5L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19370)),
    character(0),
    fixed = TRUE)

  # Testing angle(data = c(1, 2, 3, 4, 5, 6), x_col = "x...
  # Changed from baseline: data = c(1, 2, 3, 4, ...
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_12861 <- xpectr::capture_side_effects(angle(data = c(1, 2, 3, 4, 5, 6), x_col = "x", y_col = "y", origin = c(0, 0), origin_fn = NULL, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12861[['error']]),
    xpectr::strip("1 assertions failed:\n * when 'data' is not a data.frame, 'col(s)' must be 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12861[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing angle(data = NULL, x_col = "x", y_col = "y",...
  # Changed from baseline: data = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_18304 <- xpectr::capture_side_effects(angle(data = NULL, x_col = "x", y_col = "y", origin = c(0, 0), origin_fn = NULL, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18304[['error']]),
    xpectr::strip("Assertion failed. One of the following must apply:\n * checkmate::check_data_frame(data): Must be of type 'data.frame', not 'NULL'\n * checkmate::check_vector(data): Must be of type 'vector', not 'NULL'\n * checkmate::check_factor(data): Must be of type 'factor', not 'NULL'"),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18304[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing angle(data = dplyr::group_by(df, g), x_col =...
  # Changed from baseline: data, origin_fn
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16417 <- xpectr::capture_side_effects(angle(data = dplyr::group_by(df, g), x_col = "x", y_col = "y", origin = c(0, 0), origin_fn = centroid, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16417[['warnings']]),
    xpectr::strip(character(0)),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16417[['messages']]),
    xpectr::strip("When 'origin_fn' is specified, 'origin' is ignored.\n"),
    fixed = TRUE)
  # Assigning output
  output_16417 <- xpectr::suppress_mw(angle(data = dplyr::group_by(df, g), x_col = "x", y_col = "y", origin = c(0, 0), origin_fn = centroid, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = FALSE))
  # Testing class
  expect_equal(
    class(output_16417),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_16417[["x"]],
    c(0.91481, 0.93708, 0.28614, 0.83045, 0.64175, 0.5191, 0.73659,
      0.13467, 0.65699, 0.70506, 0.45774, 0.71911, 0.93467, 0.25543,
      0.46229, 0.94001, 0.97823, 0.11749, 0.475, 0.56033),
    tolerance = 1e-4)
  expect_equal(
    output_16417[["y"]],
    c(0.90403, 0.13871, 0.98889, 0.94667, 0.08244, 0.51421, 0.3902,
      0.90574, 0.44697, 0.836, 0.7376, 0.81106, 0.38811, 0.68517,
      0.00395, 0.83292, 0.00733, 0.20766, 0.9066, 0.61178),
    tolerance = 1e-4)
  expect_equal(
    output_16417[["g"]],
    c(1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4),
    tolerance = 1e-4)
  expect_equal(
    output_16417[[".degrees"]],
    c(56.55878, 294.42727, 139.16369, 72.04455, 261.38031, 253.26978,
      309.17141, 145.37563, 301.81918, 54.58247, 116.97308, 61.80384,
      339.61321, 152.73292, 258.76287, 44.45457, 305.73522, 211.60101,
      109.4902, 118.67329),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_16417),
    c("x", "y", "g", ".degrees", ".origin"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_16417),
    c("numeric", "numeric", "integer", "numeric", "list"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_16417),
    c("double", "double", "integer", "double", "list"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_16417),
    c(20L, 5L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_16417)),
    character(0),
    fixed = TRUE)

  # Testing angle(data = c(1, 2, 3, 4, 5), x_col = NULL,...
  # Changed from baseline: data, x_col, y_col, o...
  xpectr::set_test_seed(42)
  # Assigning output
  output_15190 <- angle(data = c(1, 2, 3, 4, 5), x_col = NULL, y_col = NULL, origin = NULL, origin_fn = centroid, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = FALSE)
  # Testing class
  expect_equal(
    class(output_15190),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_15190[["Index"]],
    c(1, 2, 3, 4, 5),
    tolerance = 1e-4)
  expect_equal(
    output_15190[["Value"]],
    c(1, 2, 3, 4, 5),
    tolerance = 1e-4)
  expect_equal(
    output_15190[[".degrees"]],
    c(225, 225, 0, 45, 45),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_15190),
    c("Index", "Value", ".degrees", ".origin"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_15190),
    c("integer", "numeric", "numeric", "list"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_15190),
    c("integer", "double", "double", "list"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_15190),
    5:4)
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_15190)),
    character(0),
    fixed = TRUE)

  # Testing angle(data = df, x_col = "hej", y_col = "y",...
  # Changed from baseline: x_col = "hej"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17365 <- xpectr::capture_side_effects(angle(data = df, x_col = "hej", y_col = "y", origin = c(0, 0), origin_fn = NULL, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17365[['error']]),
    xpectr::strip("1 assertions failed:\n * These names in the 'col(s)' argument were not found in 'data': hej."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17365[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing angle(data = df, x_col = 1, y_col = "y", ori...
  # Changed from baseline: x_col = 1
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_11346 <- xpectr::capture_side_effects(angle(data = df, x_col = 1, y_col = "y", origin = c(0, 0), origin_fn = NULL, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11346[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'x_col': Must be of type 'string' (or 'NULL'), not 'double'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11346[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing angle(data = df, x_col = NA, y_col = "y", or...
  # Changed from baseline: x_col = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16569 <- xpectr::capture_side_effects(angle(data = df, x_col = NA, y_col = "y", origin = c(0, 0), origin_fn = NULL, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16569[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'x_col': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16569[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing angle(data = df, x_col = NULL, y_col = "y", ...
  # Changed from baseline: x_col = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17050 <- xpectr::capture_side_effects(angle(data = df, x_col = NULL, y_col = "y", origin = c(0, 0), origin_fn = NULL, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17050[['error']]),
    xpectr::strip("1 assertions failed:\n * This mutator method requires at least 2 dimensions / columns."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17050[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing angle(data = df, x_col = "x", y_col = "x", o...
  # Changed from baseline: y_col = "x"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14577 <- xpectr::capture_side_effects(angle(data = df, x_col = "x", y_col = "x", origin = c(0, 0), origin_fn = NULL, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14577[['error']]),
    xpectr::strip("Assertion on 'specified column names (\"x\", \"x\", \".origin\", \".degrees\")' failed: Contains duplicated values, position 2."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14577[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing angle(data = df, x_col = "x", y_col = "hej",...
  # Changed from baseline: y_col = "hej"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17191 <- xpectr::capture_side_effects(angle(data = df, x_col = "x", y_col = "hej", origin = c(0, 0), origin_fn = NULL, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17191[['error']]),
    xpectr::strip("1 assertions failed:\n * These names in the 'col(s)' argument were not found in 'data': hej."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17191[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing angle(data = df, x_col = "x", y_col = 1, ori...
  # Changed from baseline: y_col = 1
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19346 <- xpectr::capture_side_effects(angle(data = df, x_col = "x", y_col = 1, origin = c(0, 0), origin_fn = NULL, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19346[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'y_col': Must be of type 'string' (or 'NULL'), not 'double'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19346[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing angle(data = df, x_col = "x", y_col = NA, or...
  # Changed from baseline: y_col = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_12554 <- xpectr::capture_side_effects(angle(data = df, x_col = "x", y_col = NA, origin = c(0, 0), origin_fn = NULL, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12554[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'y_col': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12554[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing angle(data = df, x_col = "x", y_col = NULL, ...
  # Changed from baseline: y_col = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14622 <- xpectr::capture_side_effects(angle(data = df, x_col = "x", y_col = NULL, origin = c(0, 0), origin_fn = NULL, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14622[['error']]),
    xpectr::strip("1 assertions failed:\n * This mutator method requires at least 2 dimensions / columns."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14622[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing angle(data = df, x_col = "x", y_col = "y", o...
  # Changed from baseline: origin = c(0, 0, 0)
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19400 <- xpectr::capture_side_effects(angle(data = df, x_col = "x", y_col = "y", origin = c(0, 0, 0), origin_fn = NULL, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19400[['error']]),
    xpectr::strip("'origin' must have either length 1 or same length as 'c(x_col, y_col)' (2) but had length 3."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19400[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing angle(data = df, x_col = "x", y_col = "y", o...
  # Changed from baseline: origin = c(NA, NA)
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19782 <- xpectr::capture_side_effects(angle(data = df, x_col = "x", y_col = "y", origin = c(NA, NA), origin_fn = NULL, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19782[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'origin': Contains missing values (element 1)."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19782[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing angle(data = df, x_col = "x", y_col = "y", o...
  # Changed from baseline: origin = c(1, 1)
  xpectr::set_test_seed(42)
  # Assigning output
  output_11174 <- angle(data = df, x_col = "x", y_col = "y", origin = c(1, 1), origin_fn = NULL, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = FALSE)
  # Testing class
  expect_equal(
    class(output_11174),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_11174[["x"]],
    c(0.91481, 0.93708, 0.28614, 0.83045, 0.64175, 0.5191, 0.73659,
      0.13467, 0.65699, 0.70506, 0.45774, 0.71911, 0.93467, 0.25543,
      0.46229, 0.94001, 0.97823, 0.11749, 0.475, 0.56033),
    tolerance = 1e-4)
  expect_equal(
    output_11174[["y"]],
    c(0.90403, 0.13871, 0.98889, 0.94667, 0.08244, 0.51421, 0.3902,
      0.90574, 0.44697, 0.836, 0.7376, 0.81106, 0.38811, 0.68517,
      0.00395, 0.83292, 0.00733, 0.20766, 0.9066, 0.61178),
    tolerance = 1e-4)
  expect_equal(
    output_11174[["g"]],
    c(1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4),
    tolerance = 1e-4)
  expect_equal(
    output_11174[[".degrees"]],
    c(228.40366, 265.82148, 180.8915, 197.46068, 248.67226, 225.28948,
      246.63727, 186.21679, 238.19144, 209.0758, 205.82282, 213.92755,
      263.90598, 202.92031, 241.63811, 250.25115, 268.74345, 221.91826,
      190.08745, 221.44415),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_11174),
    c("x", "y", "g", ".degrees", ".origin"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_11174),
    c("numeric", "numeric", "integer", "numeric", "list"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_11174),
    c("double", "double", "integer", "double", "list"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_11174),
    c(20L, 5L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_11174)),
    character(0),
    fixed = TRUE)

  # Testing angle(data = df, x_col = "x", y_col = "y", o...
  # Changed from baseline: origin = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14749 <- xpectr::capture_side_effects(angle(data = df, x_col = "x", y_col = "y", origin = NA, origin_fn = NULL, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14749[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'origin': Contains missing values (element 1)."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14749[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing angle(data = df, x_col = "x", y_col = "y", o...
  # Changed from baseline: origin = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_15603 <- xpectr::capture_side_effects(angle(data = df, x_col = "x", y_col = "y", origin = NULL, origin_fn = NULL, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15603[['error']]),
    xpectr::strip("1 assertions failed:\n * At least one of {'origin', 'origin_fn'} must be specified (not 'NULL')."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15603[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing angle(data = df, x_col = "x", y_col = "y", o...
  # Changed from baseline: origin_fn = centroid
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19040 <- xpectr::capture_side_effects(angle(data = df, x_col = "x", y_col = "y", origin = c(0, 0), origin_fn = centroid, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19040[['warnings']]),
    xpectr::strip(character(0)),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19040[['messages']]),
    xpectr::strip("When 'origin_fn' is specified, 'origin' is ignored.\n"),
    fixed = TRUE)
  # Assigning output
  output_19040 <- xpectr::suppress_mw(angle(data = df, x_col = "x", y_col = "y", origin = c(0, 0), origin_fn = centroid, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = FALSE))
  # Testing class
  expect_equal(
    class(output_19040),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19040[["x"]],
    c(0.91481, 0.93708, 0.28614, 0.83045, 0.64175, 0.5191, 0.73659,
      0.13467, 0.65699, 0.70506, 0.45774, 0.71911, 0.93467, 0.25543,
      0.46229, 0.94001, 0.97823, 0.11749, 0.475, 0.56033),
    tolerance = 1e-4)
  expect_equal(
    output_19040[["y"]],
    c(0.90403, 0.13871, 0.98889, 0.94667, 0.08244, 0.51421, 0.3902,
      0.90574, 0.44697, 0.836, 0.7376, 0.81106, 0.38811, 0.68517,
      0.00395, 0.83292, 0.00733, 0.20766, 0.9066, 0.61178),
    tolerance = 1e-4)
  expect_equal(
    output_19040[["g"]],
    c(1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4),
    tolerance = 1e-4)
  expect_equal(
    output_19040[[".degrees"]],
    c(48.1444, 307.08195, 127.79899, 60.19591, 273.37561, 209.44397,
      304.87747, 144.72761, 290.02044, 71.1151, 132.38254, 66.50419,
      330.86812, 161.76293, 255.00916, 39.09746, 303.103, 215.96407,
      112.15419, 139.8976),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19040),
    c("x", "y", "g", ".degrees", ".origin"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19040),
    c("numeric", "numeric", "integer", "numeric", "list"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19040),
    c("double", "double", "integer", "double", "list"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19040),
    c(20L, 5L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19040)),
    character(0),
    fixed = TRUE)

  # Testing angle(data = df, x_col = "x", y_col = "y", o...
  # Changed from baseline: origin_fn = most_cent...
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_11387 <- xpectr::capture_side_effects(angle(data = df, x_col = "x", y_col = "y", origin = c(0, 0), origin_fn = most_centered, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11387[['warnings']]),
    xpectr::strip(character(0)),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11387[['messages']]),
    xpectr::strip("When 'origin_fn' is specified, 'origin' is ignored.\n"),
    fixed = TRUE)
  # Assigning output
  output_11387 <- xpectr::suppress_mw(angle(data = df, x_col = "x", y_col = "y", origin = c(0, 0), origin_fn = most_centered, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = FALSE))
  # Testing class
  expect_equal(
    class(output_11387),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_11387[["x"]],
    c(0.91481, 0.93708, 0.28614, 0.83045, 0.64175, 0.5191, 0.73659,
      0.13467, 0.65699, 0.70506, 0.45774, 0.71911, 0.93467, 0.25543,
      0.46229, 0.94001, 0.97823, 0.11749, 0.475, 0.56033),
    tolerance = 1e-4)
  expect_equal(
    output_11387[["y"]],
    c(0.90403, 0.13871, 0.98889, 0.94667, 0.08244, 0.51421, 0.3902,
      0.90574, 0.44697, 0.836, 0.7376, 0.81106, 0.38811, 0.68517,
      0.00395, 0.83292, 0.00733, 0.20766, 0.9066, 0.61178),
    tolerance = 1e-4)
  expect_equal(
    output_11387[["g"]],
    c(1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4),
    tolerance = 1e-4)
  expect_equal(
    output_11387[[".degrees"]],
    c(39.50457, 308.53314, 126.02033, 51.11108, 278.74359, 247.08857,
      308.50106, 145.37155, 300.39138, 57.15877, 129.19375, 51.45287,
      329.1414, 166.46622, 260.8374, 30.21774, 304.65875, 222.38209,
      106.14295, 0),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_11387),
    c("x", "y", "g", ".degrees", ".origin"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_11387),
    c("numeric", "numeric", "integer", "numeric", "list"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_11387),
    c("double", "double", "integer", "double", "list"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_11387),
    c(20L, 5L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_11387)),
    character(0),
    fixed = TRUE)

  # Testing angle(data = df, x_col = "x", y_col = "y", o...
  # Changed from baseline: degrees_col_name = "....
  xpectr::set_test_seed(42)
  # Assigning output
  output_19888 <- angle(data = df, x_col = "x", y_col = "y", origin = c(0, 0), origin_fn = NULL, degrees_col_name = ".gredees", origin_col_name = ".origin", overwrite = FALSE)
  # Testing class
  expect_equal(
    class(output_19888),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19888[["x"]],
    c(0.91481, 0.93708, 0.28614, 0.83045, 0.64175, 0.5191, 0.73659,
      0.13467, 0.65699, 0.70506, 0.45774, 0.71911, 0.93467, 0.25543,
      0.46229, 0.94001, 0.97823, 0.11749, 0.475, 0.56033),
    tolerance = 1e-4)
  expect_equal(
    output_19888[["y"]],
    c(0.90403, 0.13871, 0.98889, 0.94667, 0.08244, 0.51421, 0.3902,
      0.90574, 0.44697, 0.836, 0.7376, 0.81106, 0.38811, 0.68517,
      0.00395, 0.83292, 0.00733, 0.20766, 0.9066, 0.61178),
    tolerance = 1e-4)
  expect_equal(
    output_19888[["g"]],
    c(1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4),
    tolerance = 1e-4)
  expect_equal(
    output_19888[[".gredees"]],
    c(44.66059, 8.42004, 73.862, 48.74173, 7.32003, 44.72918, 27.91215,
      81.54313, 34.22851, 49.85657, 58.17683, 48.43859, 22.54992,
      69.55472, 0.48934, 41.5431, 0.42956, 60.50009, 62.34854, 47.51319),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19888),
    c("x", "y", "g", ".gredees", ".origin"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19888),
    c("numeric", "numeric", "integer", "numeric", "list"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19888),
    c("double", "double", "integer", "double", "list"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19888),
    c(20L, 5L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19888)),
    character(0),
    fixed = TRUE)

  # Testing angle(data = df, x_col = "x", y_col = "y", o...
  # Changed from baseline: degrees_col_name = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19466 <- xpectr::capture_side_effects(angle(data = df, x_col = "x", y_col = "y", origin = c(0, 0), origin_fn = NULL, degrees_col_name = NA, origin_col_name = ".origin", overwrite = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19466[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'degrees_col_name': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19466[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing angle(data = df, x_col = "x", y_col = "y", o...
  # Changed from baseline: degrees_col_name = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_10824 <- xpectr::capture_side_effects(angle(data = df, x_col = "x", y_col = "y", origin = c(0, 0), origin_fn = NULL, degrees_col_name = NULL, origin_col_name = ".origin", overwrite = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_10824[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'degrees_col_name': Must be of type 'string', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_10824[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing angle(data = df, x_col = "x", y_col = "y", o...
  # Changed from baseline: origin_col_name = ".o...
  xpectr::set_test_seed(42)
  # Assigning output
  output_15142 <- angle(data = df, x_col = "x", y_col = "y", origin = c(0, 0), origin_fn = NULL, degrees_col_name = ".degrees", origin_col_name = ".oruguay", overwrite = FALSE)
  # Testing class
  expect_equal(
    class(output_15142),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_15142[["x"]],
    c(0.91481, 0.93708, 0.28614, 0.83045, 0.64175, 0.5191, 0.73659,
      0.13467, 0.65699, 0.70506, 0.45774, 0.71911, 0.93467, 0.25543,
      0.46229, 0.94001, 0.97823, 0.11749, 0.475, 0.56033),
    tolerance = 1e-4)
  expect_equal(
    output_15142[["y"]],
    c(0.90403, 0.13871, 0.98889, 0.94667, 0.08244, 0.51421, 0.3902,
      0.90574, 0.44697, 0.836, 0.7376, 0.81106, 0.38811, 0.68517,
      0.00395, 0.83292, 0.00733, 0.20766, 0.9066, 0.61178),
    tolerance = 1e-4)
  expect_equal(
    output_15142[["g"]],
    c(1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4),
    tolerance = 1e-4)
  expect_equal(
    output_15142[[".degrees"]],
    c(44.66059, 8.42004, 73.862, 48.74173, 7.32003, 44.72918, 27.91215,
      81.54313, 34.22851, 49.85657, 58.17683, 48.43859, 22.54992,
      69.55472, 0.48934, 41.5431, 0.42956, 60.50009, 62.34854, 47.51319),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_15142),
    c("x", "y", "g", ".degrees", ".oruguay"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_15142),
    c("numeric", "numeric", "integer", "numeric", "list"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_15142),
    c("double", "double", "integer", "double", "list"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_15142),
    c(20L, 5L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_15142)),
    character(0),
    fixed = TRUE)

  # Testing angle(data = df, x_col = "x", y_col = "y", o...
  # Changed from baseline: origin_col_name = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_13902 <- xpectr::capture_side_effects(angle(data = df, x_col = "x", y_col = "y", origin = c(0, 0), origin_fn = NULL, degrees_col_name = ".degrees", origin_col_name = NA, overwrite = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_13902[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'origin_col_name': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_13902[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing angle(data = df, x_col = "x", y_col = "y", o...
  # Changed from baseline: origin_col_name = NULL
  xpectr::set_test_seed(42)
  # Assigning output
  output_19057 <- angle(data = df, x_col = "x", y_col = "y", origin = c(0, 0), origin_fn = NULL, degrees_col_name = ".degrees", origin_col_name = NULL, overwrite = FALSE)
  # Testing class
  expect_equal(
    class(output_19057),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19057[["x"]],
    c(0.91481, 0.93708, 0.28614, 0.83045, 0.64175, 0.5191, 0.73659,
      0.13467, 0.65699, 0.70506, 0.45774, 0.71911, 0.93467, 0.25543,
      0.46229, 0.94001, 0.97823, 0.11749, 0.475, 0.56033),
    tolerance = 1e-4)
  expect_equal(
    output_19057[["y"]],
    c(0.90403, 0.13871, 0.98889, 0.94667, 0.08244, 0.51421, 0.3902,
      0.90574, 0.44697, 0.836, 0.7376, 0.81106, 0.38811, 0.68517,
      0.00395, 0.83292, 0.00733, 0.20766, 0.9066, 0.61178),
    tolerance = 1e-4)
  expect_equal(
    output_19057[["g"]],
    c(1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4),
    tolerance = 1e-4)
  expect_equal(
    output_19057[[".degrees"]],
    c(44.66059, 8.42004, 73.862, 48.74173, 7.32003, 44.72918, 27.91215,
      81.54313, 34.22851, 49.85657, 58.17683, 48.43859, 22.54992,
      69.55472, 0.48934, 41.5431, 0.42956, 60.50009, 62.34854, 47.51319),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_19057),
    c("x", "y", "g", ".degrees"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19057),
    c("numeric", "numeric", "integer", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19057),
    c("double", "double", "integer", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19057),
    c(20L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19057)),
    character(0),
    fixed = TRUE)

  # Testing angle(data = df, x_col = "x", y_col = "y", o...
  # Changed from baseline: origin_col_name, over...
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14469 <- xpectr::capture_side_effects(angle(data = df, x_col = "x", y_col = "y", origin = c(0, 0), origin_fn = NULL, degrees_col_name = ".degrees", origin_col_name = "x", overwrite = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14469[['error']]),
    xpectr::strip("Assertion on 'specified column names (\"x\", \"y\", \"x\", \".degrees\")' failed: Contains duplicated values, position 3."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14469[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing angle(data = df, x_col = "x", y_col = "y", o...
  # Changed from baseline: origin_col_name, over...
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_18360 <- xpectr::capture_side_effects(angle(data = df, x_col = "x", y_col = "y", origin = c(0, 0), origin_fn = NULL, degrees_col_name = ".degrees", origin_col_name = "g", overwrite = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18360[['error']]),
    xpectr::strip("1 assertions failed:\n * The column 'g' already exists and 'overwrite' is disabled."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18360[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing angle(data = df, x_col = "x", y_col = "y", o...
  # Changed from baseline: origin_col_name, over...
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_17375 <- xpectr::capture_side_effects(angle(data = df, x_col = "x", y_col = "y", origin = c(0, 0), origin_fn = NULL, degrees_col_name = ".degrees", origin_col_name = "x", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17375[['error']]),
    xpectr::strip("Assertion on 'specified column names (\"x\", \"y\", \"x\", \".degrees\")' failed: Contains duplicated values, position 3."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_17375[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing angle(data = df, x_col = "x", y_col = "y", o...
  # Changed from baseline: overwrite = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_18110 <- xpectr::capture_side_effects(angle(data = df, x_col = "x", y_col = "y", origin = c(0, 0), origin_fn = NULL, degrees_col_name = ".degrees", origin_col_name = ".origin", overwrite = NULL), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18110[['error']]),
    xpectr::strip("Assertion on 'overwrite' failed: Must be of type 'logical flag', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18110[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  ## Finished testing 'angle'                                                 ####
  #
})
