% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rev_windows.R
\name{rev_windows}
\alias{rev_windows}
\alias{rev_windows_vec}
\title{Reverse order window-wise}
\usage{
rev_windows(data, window_size, factor_name = ".window", overwrite = FALSE)

rev_windows_vec(data, window_size)
}
\arguments{
\item{data}{\code{data.frame} or \code{vector}.}

\item{window_size}{Size of the windows. (Logical)}

\item{factor_name}{Name of the factor with window identifiers.
If \code{NULL}, no column is added.}

\item{overwrite}{Whether to allow overwriting of existing columns. (Logical)}
}
\value{
The sorted \code{data.frame} (\code{tibble}) / \code{vector}.
Optionally with the windows factor added.

When \code{`data`} is a \code{vector} and \code{`keep_windows`} is \code{FALSE},
the output will be a \code{vector}. Otherwise, a \code{data.frame}.
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("experimental")}

The values are windowed and reversed within windows.

The \code{*_vec()} version takes and returns a \code{vector}.

\strong{Example}:

The column values:

\code{c(1, 2, 3, 4, 5, 6)}

With \code{window_size = 3}

Are \strong{ordered as}:

\code{c(3, 2, 1, 6, 4, 5)}
}
\examples{
# Attach packages
library(rearrr)
library(dplyr)

# Set seed
set.seed(1)

# Create a data frame
df <- data.frame(
  "index" = 1:10,
  "A" = sample(1:10),
  "B" = runif(10),
  "C" = LETTERS[1:10],
  "G" = rep(1:2, each = 5),
  stringsAsFactors = FALSE
)

# For vector
rev_windows_vec(1:10, window_size = 3)

# For data frame
rev_windows(df, window_size = 3)
rev_windows(df, window_size = 3, factor_name = NULL)

# Grouped by G
df \%>\%
  dplyr::select(G, index) \%>\% # For clarity
  dplyr::group_by(G) \%>\%
  rev_windows(window_size = 3)

# Plot the extreme pairs
plot(
  x = 1:10,
  y = rev_windows_vec(1:10, window_size = 3)
)
}
\seealso{
Other rearrange functions: 
\code{\link{center_max}()},
\code{\link{center_min}()},
\code{\link{closest_to}()},
\code{\link{furthest_from}()},
\code{\link{pair_extremes}()},
\code{\link{position_max}()},
\code{\link{position_min}()},
\code{\link{roll_elements}()},
\code{\link{shuffle_hierarchy}()}
}
\author{
Ludvig Renbo Olsen, \email{r-pkgs@ludvigolsen.dk}
}
\concept{rearrange functions}
