% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_unit_length.R
\name{to_unit_length}
\alias{to_unit_length}
\alias{to_unit_length_vec}
\title{Scale to unit length}
\usage{
to_unit_length(
  data,
  cols = NULL,
  by_row = is.data.frame(data),
  suffix = ifelse(isTRUE(by_row), "_row_unit", "_col_unit"),
  overwrite = FALSE
)

to_unit_length_vec(data)
}
\arguments{
\item{data}{\code{data.frame} or \code{vector}.}

\item{cols}{Names of columns in \code{`data`} to scale.}

\item{by_row}{Whether to scale row \code{vector}s instead of column \code{vector}s. (Logical)

Note: Disable when \code{`data`} is a \code{vector}.}

\item{suffix}{Suffix to add to the names of the generated columns.

Use an empty string (i.e. \code{""}) to overwrite the original columns.}

\item{overwrite}{Whether to allow overwriting of existing columns. (Logical)}
}
\value{
Scaled \code{vector} or \code{data.frame} (\code{tibble}) with the scaled columns.
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("experimental")}

Scales the vectors to unit length \emph{row-wise} or \emph{column-wise}.

The \code{*_vec()} version take and return a \code{vector}.
}
\examples{
# Attach packages
library(rearrr)
library(dplyr)

# Set seed
set.seed(1)

# Create a data frame
df <- data.frame(
  "x" = runif(20),
  "y" = runif(20),
  "g" = rep(1:4, each = 5)
)

# Scale row-wise
to_unit_length(df, cols = c("x", "y"), by_row = TRUE)

# Scale column-wise
to_unit_length(df, cols = c("x", "y"), by_row = FALSE)

# Overwrite columns
to_unit_length(df, cols = c("x", "y"), suffix = "", overwrite = TRUE)

# By groups in 'g'
df \%>\%
  dplyr::group_by(g) \%>\%
  to_unit_length(cols = c("x", "y"), by_row = FALSE)

# Scale a vector
to_unit_length_vec(c(1:10))
to_unit_length(c(1:10), suffix = "", overwrite = TRUE)
vector_length(to_unit_length_vec(c(1:10)))
}
\seealso{
Other scaling functions: 
\code{\link{min_max_scale}()}
}
\author{
Ludvig Renbo Olsen, \email{r-pkgs@ludvigolsen.dk}
}
\concept{scaling functions}
