% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebirdregioncheck.R
\name{ebirdregioncheck}
\alias{ebirdregioncheck}
\title{Check if a region type is valid}
\usage{
ebirdregioncheck(loc, key = NULL, ...)
}
\arguments{
\item{loc}{The location code to be checked.}

\item{key}{ebird API key. You can obtain one from https://ebird.org/api/keygen.
We strongly recommend storing it in your \code{.Renviron} file as an 
environment variable called \code{EBIRD_KEY}.}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}
}
\value{
Logical.
}
\description{
Check if a region type is valid
}
\examples{
\dontrun{
ebirdregioncheck("US")
ebirdregioncheck("CA-BC")
ebirdregioncheck("CA-BC-GV")
}
}
\references{
\url{http://ebird.org/}
}
\author{
Sebastian Pardo \email{sebpardo@gmail.com},
   Andy Teucher \email{andy.teucher@gmail.com}
}
