% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backreferences.R
\name{recursive}
\alias{recursive}
\title{Make the regular expression recursive.}
\usage{
recursive(x)
}
\arguments{
\item{x}{A character vector.}
}
\value{
A character vector representing part or all of a regular expression.
}
\description{
Makes the regular expression (or part of it) recursive.
}
\note{
Recursion is not supported by R's internal PRCE engine or
\code{stringi}'s ICU engine.
}
\examples{
recursive("a")

# Recursion isn't supported by R's PRCE engine or
# stringi/stringr's ICU engine
x <- c("ab222z", "ababz", "ab", "abab")
rx <- "ab(?R)?z"
grepl(rx, x, perl = TRUE)
try(grepl(rx, x))
try(stringi::stri_detect_regex(x, rx))
}
\references{
\url{http://www.regular-expressions.info/recurse.html} and
\url{http://www.rexegg.com/regex-recursion.html}
}

