% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upsample.R
\name{step_upsample}
\alias{step_upsample}
\title{Up-Sample a Data Set Based on a Factor Variable}
\usage{
step_upsample(
  recipe,
  ...,
  over_ratio = 1,
  ratio = NA,
  role = NA,
  trained = FALSE,
  column = NULL,
  target = NA,
  skip = TRUE,
  seed = sample.int(10^5, 1),
  id = rand_id("upsample")
)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose variables
for this step. See \code{\link[=selections]{selections()}} for more details.}

\item{over_ratio}{A numeric value for the ratio of the
majority-to-minority frequencies. The default value (1) means
that all other levels are sampled up to have the same
frequency as the most occurring level. A value of 0.5 would mean
that the minority levels will have (at most) (approximately)
half as many rows than the majority level.}

\item{ratio}{Deprecated argument; same as \code{over_ratio}.}

\item{role}{Not used by this step since no new variables are
created.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{column}{A character string of the variable name that will
be populated (eventually) by the \code{...} selectors.}

\item{target}{An integer that will be used to subsample. This
should not be set by the user and will be populated by \code{prep}.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[=bake]{bake()}}? While all operations are baked
when \code{\link[=prep]{prep()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations.}

\item{seed}{An integer that will be used as the seed when upsampling.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of \code{recipe} with the new step added to the
sequence of any existing operations.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\code{step_upsample} is now available as \code{themis::step_upsample()}. This
function creates a \emph{specification} of a recipe step that
will replicate rows of a data set to make the occurrence of
levels in a specific factor level equal.
}
\details{
Up-sampling is intended to be performed on the \emph{training} set alone. For
this reason, the default is \code{skip = TRUE}. It is advisable to use
\code{prep(recipe, retain = TRUE)} when preparing the recipe; in this way
\code{bake(object, new_data = NULL)} can be used to obtain the up-sampled version
of the data.

If there are missing values in the factor variable that is used
to define the sampling, missing data are selected at random in
the same way that the other factor levels are sampled. Missing
values are not used to determine the amount of data in the
majority level (see example below).

For any data with factor levels occurring with the same
frequency as the majority level, all data will be retained.

All columns in the data are sampled and returned by \code{\link[=bake]{bake()}}.

When used in modeling, users should strongly consider using the
option \code{skip = TRUE} so that the extra sampling is \emph{not}
conducted outside of the training set.
}
\keyword{internal}
