% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other.R
\name{step_other}
\alias{step_other}
\title{Collapse infrequent categorical levels}
\usage{
step_other(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  threshold = 0.05,
  other = "other",
  objects = NULL,
  skip = FALSE,
  id = rand_id("other")
)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose variables
for this step. See \code{\link[=selections]{selections()}} for more details.}

\item{role}{Not used by this step since no new variables are
created.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{threshold}{A numeric value between 0 and 1, or an integer greater or
equal to one.  If less than one, then factor levels with a rate of
occurrence in the training set below \code{threshold} will be pooled to \code{other}.
If greater or equal to one, then this value is treated as a frequency
and factor levels that occur less than \code{threshold} times will be pooled
to \code{other}.}

\item{other}{A single character value for the "other" category.}

\item{objects}{A list of objects that contain the information
to pool infrequent levels that is determined by
\code{\link[=prep]{prep()}}.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[=bake]{bake()}}? While all operations are baked
when \code{\link[=prep]{prep()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of \code{recipe} with the new step added to the
sequence of any existing operations.
}
\description{
\code{step_other()} creates a \emph{specification} of a recipe step that will
potentially pool infrequently occurring values into an \code{"other"} category.
}
\details{
The overall proportion (or total counts) of the categories are
computed. The "other" category is used in place of any categorical levels
whose individual proportion (or frequency) in the training set is less than
\code{threshold}.

If no pooling is done the data are unmodified (although character data may
be changed to factors based on the value of \code{strings_as_factors} in
\code{\link[=prep]{prep()}}). Otherwise, a factor is always returned with
different factor levels.

If \code{threshold} is less than the largest category proportion, all levels
except for the most frequent are collapsed to the \code{other} level.

If the retained categories include the value of \code{other}, an error is
thrown. If \code{other} is in the list of discarded levels, no error
occurs.

If no pooling is done, novel factor levels are converted to missing. If
pooling is needed, they will be placed into the other category.

When data to be processed contains novel levels (i.e., not
contained in the training set), the other category is assigned.
}
\section{Tidying}{
When you \code{\link[=tidy.recipe]{tidy()}} this step, a tibble is returned with
columns \code{terms}, \code{retained} , and \code{id}:

\describe{
\item{terms}{character, the selectors or variables selected}
\item{retained}{character, factor levels not pulled into \code{"other"}}
\item{id}{character, id of this step}
}
}

\section{Tuning Parameters}{
This step has 1 tuning parameters:
\itemize{
\item \code{threshold}: Threshold (type: double, default: 0.05)
}
}

\section{Case weights}{


This step performs an unsupervised operation that can utilize case weights.
As a result, case weights are only used with frequency weights. For more
information, see the documentation in \link{case_weights} and the examples on
\code{tidymodels.org}.
}

\examples{
\dontshow{if (rlang::is_installed("modeldata")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data(Sacramento, package = "modeldata")

set.seed(19)
in_train <- sample(1:nrow(Sacramento), size = 800)

sacr_tr <- Sacramento[in_train, ]
sacr_te <- Sacramento[-in_train, ]

rec <- recipe(~ city + zip, data = sacr_tr)


rec <- rec \%>\%
  step_other(city, zip, threshold = .1, other = "other values")
rec <- prep(rec, training = sacr_tr)

collapsed <- bake(rec, sacr_te)
table(sacr_te$city, collapsed$city, useNA = "always")

tidy(rec, number = 1)

# novel levels are also "othered"
tahiti <- Sacramento[1, ]
tahiti$zip <- "a magical place"
bake(rec, tahiti)

# threshold as a frequency
rec <- recipe(~ city + zip, data = sacr_tr)

rec <- rec \%>\%
  step_other(city, zip, threshold = 2000, other = "other values")
rec <- prep(rec, training = sacr_tr)

tidy(rec, number = 1)
# compare it to
# sacr_tr \%>\% count(city, sort = TRUE) \%>\% top_n(4)
# sacr_tr \%>\% count(zip, sort = TRUE) \%>\% top_n(3)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=dummy_names]{dummy_names()}}

Other dummy variable and encoding steps: 
\code{\link{step_bin2factor}()},
\code{\link{step_count}()},
\code{\link{step_date}()},
\code{\link{step_dummy}()},
\code{\link{step_dummy_extract}()},
\code{\link{step_dummy_multi_choice}()},
\code{\link{step_factor2string}()},
\code{\link{step_holiday}()},
\code{\link{step_indicate_na}()},
\code{\link{step_integer}()},
\code{\link{step_novel}()},
\code{\link{step_num2factor}()},
\code{\link{step_ordinalscore}()},
\code{\link{step_regex}()},
\code{\link{step_relevel}()},
\code{\link{step_string2factor}()},
\code{\link{step_time}()},
\code{\link{step_unknown}()},
\code{\link{step_unorder}()}
}
\concept{dummy variable and encoding steps}
