% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recolorize_adjacency.R
\name{rgb2hsl}
\alias{rgb2hsl}
\title{Convert RGB colors to HSL}
\usage{
rgb2hsl(rgb_matrix, radians = TRUE, pavo_hsl = TRUE)
}
\arguments{
\item{rgb_matrix}{RGB colors in an nx3 matrix (rows = colors,
columns = channels).}

\item{radians}{Logical. Return HSL colors in units of radians
(\code{TRUE}) or degrees (\code{FALSE})?}

\item{pavo_hsl}{Logical. Return HSL matrix in a format that
can be passed directly to \link[pavo:adjacent]{pavo::adjacent} as the \code{hsl} parameter?}
}
\value{
A dataframe with \code{patch}, \code{hue}, \code{sat}, and \code{lum} columns
and one row per color (if \code{pavo_hsl = TRUE}) or a matrix of the HSL
coordinates (if \code{pavo_hsl = FALSE}).
}
\description{
Convert RGB colors (0-1 range) to HSL (hue-saturation-luminance)
space. Used for passing RGB colors to \link[pavo:adjacent]{pavo::adjacent}.
}
