% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Recordr.R
\docType{methods}
\name{selectRuns}
\alias{selectRuns}
\alias{selectRuns,Recordr-method}
\title{Select runs that match search parameters}
\usage{
selectRuns(recordr, ...)

\S4method{selectRuns}{Recordr}(recordr, runId = as.character(NA),
  script = as.character(NA), startTime = as.character(NA),
  endTime = as.character(NA), tag = as.character(NA),
  errorMessage = as.character(NA), seq = as.integer(NA),
  orderBy = "-startTime", delete = FALSE)
}
\arguments{
\item{recordr}{A Recordr instance}

\item{...}{additional parameters}

\item{runId}{An execution identifiers}

\item{script}{The flle name of script to match.}

\item{startTime}{Match executions that started after this time (inclusive)}

\item{endTime}{Match executions that ended before this time (inclusive)}

\item{tag}{The text of tag to match.}

\item{errorMessage}{The text of error message to match.}

\item{seq}{The run sequence number}

\item{orderBy}{The column that will be used to sort the output. This can include a minus sign before the name, e.g. -startTime}

\item{delete}{A logical value, if TRUE then the selected runs are deleted from the Recordr database.}
}
\value{
A data.frame that contains execution metadata for executions that matched the search criteria
}
\description{
This method is used to retrieve execution metadata for 
runs that match the search parameters.
}
\details{
This method is used internally by the \emph{recordr} package.
}
\seealso{
\code{\link[=Recordr-class]{Recordr}} { class description}
}

