% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RecoSys.R
\name{predict}
\alias{predict}
\title{Recommender Model Predictions}
\arguments{
\item{r}{Object returned by \code{\link{Reco}()}.}

\item{train_data}{An object of class "DataSource" that describes the source
of testing data, typically returned by function
\code{\link{data_file}()} or \code{\link{data_memory}()}.}

\item{out_pred}{An object of class \code{Output} that specifies the
output format of prediction, typically returned by function
\code{\link{out_file}()}, \code{\link{out_memory}()} or
\code{\link{out_nothing}()}.
\code{\link{out_file}()} writes the result into a
file, \code{\link{out_memory}()} exports the vector of
predicted values into the return value of \code{$predict()},
and \code{\link{out_nothing}()} means the result will be
neither returned nor written into a file (but computation will
still be conducted).}
}
\description{
This method is a member function of class "\code{RecoSys}"
that predicts unknown entries in the rating matrix.

Prior to calling this method, model needs to be trained using member function
\code{$\link{train}()}.

The common usage of this method is
\preformatted{r = Reco()
r$train(...)
r$predict(test_data, out_pred = data_file("predict.txt")}
}
\examples{
\dontrun{
train_file = data_file(system.file("dat", "smalltrain.txt", package = "recosystem"))
test_file = data_file(system.file("dat", "smalltest.txt", package = "recosystem"))
r = Reco()
set.seed(123) # This is a randomized algorithm
opts_tune = r$tune(train_file)$min
r$train(train_file, opts = opts_tune)

## Write predicted values into file
out_pred = out_file(tempfile())
r$predict(test_file, out_pred)

## Return predicted values in memory
pred = r$predict(test_file, out_memory())

## If testing data are stored in memory
test_df = read.table(test_file@source, sep = " ", header = FALSE)
pred2 = r$predict(data_memory(test_df[, 1], test_df[, 2]), out_memory())

## Compare results
print(scan(out_pred@dest, n = 10))
head(pred, 10)
head(pred2, 10)
}

}
\references{
W.-S. Chin, Y. Zhuang, Y.-C. Juan, and C.-J. Lin.
A Fast Parallel Stochastic Gradient Method for Matrix Factorization in Shared Memory Systems.
ACM TIST, 2015.

W.-S. Chin, Y. Zhuang, Y.-C. Juan, and C.-J. Lin.
A Learning-rate Schedule for Stochastic Gradient Methods to Matrix Factorization.
PAKDD, 2015.

W.-S. Chin, B.-W. Yuan, M.-Y. Yang, Y. Zhuang, Y.-C. Juan, and C.-J. Lin.
LIBMF: A Library for Parallel Matrix Factorization in Shared-memory Systems.
Technical report, 2015.
}
\seealso{
\code{$\link{train}()}
}
\author{
Yixuan Qiu <\url{http://statr.me}>
}
