% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/exportArms.R
\name{exportArms}
\alias{exportArms}
\alias{exportArms.redcapApiConnection}
\alias{exportArms.redcapDbConnection}
\title{Exports the Arms for a Project}
\usage{
exportArms(rcon, arms, ...)

\method{exportArms}{redcapDbConnection}(rcon, arms, ...)

\method{exportArms}{redcapApiConnection}(rcon, arms, ...)
}
\arguments{
\item{rcon}{A REDCap connection object as generated by \code{redcapConnection}}

\item{arms}{A vector of arm numbers that you wish to pull events for (by default,
all events are pulled).  A bug exists in early versions of the API that causes
all arms to be returned regardless of this argument.  This bug was fixed in
version 5.9.15}

\item{...}{Arguments to be passed to other methods}
}
\description{
Retrieve a data frame giving the event IDs and event names
  of a project
}
\details{
The data frame that is returned shows the arm number, and arm name.

When this function is called for a classic project, a character string is
returned giving the API error message, '400: You cannot export arms for
classic projects' but without casting an error in R. This is by design and
allows more flexible error checks in certain functions.
}
\examples{
\dontrun{
  > #*** Note: I cannot provide working examples without
  > #*** compromising security.  Instead, I will try to
  > #*** offer up sample code with the matching results
  >
  >
  > #*** Create the connection object
  > rcon <- redcapConnection(url=[YOUR_REDCAP_URL], token=[API_TOKEN])
  >
  > exportArms(rcon)
  arm_num             name
  1       1            Arm 1
  2       2 Experimental Arm
  3      10   Normal Control
  }
}
\author{
Benjamin Nutter
}
\references{
Please refer to your institution's API documentation.

Additional details on API parameters are found on the package wiki at
\url{https://github.com/nutterb/redcapAPI/wiki/REDCap-API-Parameters}
}

