% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/exportFiles.R
\name{exportFiles}
\alias{exportFiles}
\alias{exportFiles.redcapApiConnection}
\alias{exportFiles.redcapDbConnection}
\title{Exports a File attached to a Record}
\usage{
exportFiles(rcon, record, field, event, dir, filePrefix = TRUE, ...,
  proj = NULL)

\method{exportFiles}{redcapDbConnection}(rcon, record, field, event, dir,
  filePrefix = TRUE, ..., proj = NULL)

\method{exportFiles}{redcapApiConnection}(rcon, record, field, event, dir,
  filePrefix = TRUE, ..., proj = NULL)
}
\arguments{
\item{rcon}{A REDCap connection object as generated by \code{redcapConnection}}

\item{record}{The record ID in which the desired file is stored. Must be length 1.}

\item{field}{The field name in which the file is stored. Must be length 1.}

\item{event}{The event name for the file.  Must be length 1.
This applies only to longitudinal projects.  If the event is not
supplied for a longitudinal project, the API will return an error message}

\item{dir}{A directory/folder to which the file will be saved.
By default, the working directory is used}

\item{filePrefix}{Logical.  Determines if a prefix is appended to the file
name.  The prefix takes the form [record_id]-[event_name]-[file_name].
The file name is always the same name of the file as it exists in REDCap}

\item{...}{Arguments to be passed to other methods}

\item{proj}{A \code{redcapProject} object as created by \code{redcapProjectInfo}.}
}
\description{
A single file from a single record is retrieved.  The behavior
of this function is consistent with the behavior of the API, which only
allows one file to be downloaded at a time
}
\details{
The function may only export a single file.
See the examples for suggestions on exporting multiple files.

Note that the name of the file can not be changed.  Whatever name exists in
REDCap is the name that will be used, although the record ID and event name
may be appended as a prefix
}
\examples{
\dontrun{
 > #*** Note: I cannot provide working examples without
 > #*** compromising security.  Instead, I will try to
 > #*** offer up sample code with the matching results
 >
 > #*** Create the connection object
 > rcon <- redcapConnection(url=[YOUR_REDCAP_URL], token=[API_TOKEN])
 >
 >
 > #* Export a single file
 > exportFiles(rcon, record=1, field="file_upload", event="event_1_arm_1")
 The file was saved to '1-event_1_arm_1-NewOutcomes.xlsx'
 >
 >
 > #* Export all files in a project
 > #* Although this example only shows one field for files, it could work with
 > #* an arbitrary number of file upload fields
 > library(reshape2)
 > Data <- exportRecords(Data)
 > (filesToExport <- melt(Data[, c("id", "redcap_event_name", "file_upload")],
                          c("id", "redcap_event_name")),
                          na.rm=TRUE)
 id redcap_event_name    variable      value
 1  1     event_1_arm_1 file_upload [document]
 4  2     event_1_arm_1 file_upload [document]
 >
 > for(i in 1:nrow(filesToExport)){
 +   exportFiles(rcon, record=filesToExport$id[i],
 +               field=filesToExport$variable[i],
 +               event=filesToExport$redcap_event_name[i])
 + }
 The file was saved to '1-event_1_arm_1-NewOutcomes.xlsx'
 The file was saved to '2-event_1_arm_1-Sunset2.JPG'
 }
}
\author{
Benjamin Nutter
}
\references{
Please refer to your institution's API documentation.

Additional details on API parameters are found on the package wiki at
\url{https://github.com/nutterb/redcapAPI/wiki/REDCap-API-Parameters}
}

