% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missingSummary.R
\name{missingSummary}
\alias{missingSummary}
\alias{missingSummary_offline}
\alias{missingSummary.redcapApiConnection}
\title{Report of Missing Values}
\usage{
missingSummary(rcon, excludeMissingForms = TRUE, ...)

\method{missingSummary}{redcapApiConnection}(rcon, excludeMissingForms = TRUE, ...)

missingSummary_offline(records, meta_data, excludeMissingForms = TRUE)
}
\arguments{
\item{rcon}{A \code{redcapConnection} object.}

\item{excludeMissingForms}{\code{logical(1)} When \code{TRUE}, forms where all
fields are missing are assumed to be deliberately missing data and
are excluded from the count of missing values. An example when this is
desirable is if a patient did not experience an adverse event;
the adverse event form would contain no data and the empty fields
should not be considered missing data.}

\item{...}{additional arguments passed to inner call of exportRecordsTyped.}

\item{records}{\code{character(1)} A filename pointing to the raw records
download from REDCap.}

\item{meta_data}{\code{character(1)} A filename pointing to the data dictionary
download from REDCap.}
}
\description{
Returns a data frame of subject events with missing values.
}
\details{
The intention of this function is to generate a list of subject
events that are missing and could potentially be values that should have
been entered.

The branching logic from the data dictionary is parsed and translated into
and R expression.  When a field with branching logic passes the logical
statement, it is evaluated with \code{is.na}, otherwise, it is set to
\code{FALSE} (non-missing, because there was never an opportunity to
provide a value).  The utility of this function is limited to simple
logic where all of the
data exist within the same row. Any complex statements using events
will result in a failure.

Optionally, forms that are entirely missing can be determined to be
non-missing.  This is applicable when, for instance, a patient did not
have an adverse event.  In this case, a form dedicated to adverse events
would contain meaningless missing values and could be excluded from the
report.
}
\examples{
\dontrun{
unlockREDCap(connections = c(rcon = "project_alias"), 
             url = "your_redcap_url", 
             keyring = "API_KEYs", 
             envir = globalenv())
             
# Generate a summary of missing values for the entire project
missingSummary(rcon)

# Generate a summary of missing values for a single form
missingSummary(rcon, 
               exportRecordsArgs = list(forms = "target_form"))
}

}
\seealso{
\code{vignette("redcapAPI-offline-connection", package = "redcapAPI")}
}
