% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eqc_SmallGaps.R
\name{eqc_SmallGaps}
\alias{eqc_SmallGaps}
\title{Small gaps level of daily precipitation}
\usage{
eqc_SmallGaps(
  xts_obj,
  lmn_yday = 365 * 80/100,
  ths = list(lv0 = c(percent = 0), lv1to2 = c(percent = 20))
)
}
\arguments{
\item{xts_obj}{xts of a single time series}

\item{lmn_yday}{numeric value of the minimum number of days to be considered a complete year. The default value is 365 * 80 / 100 days}

\item{ths}{list. List of parameters to define in which level would be the daily precipitation.}
}
\description{
The function determine the level (0, 1 or 2) of the small gaps test
}
\details{
Small gaps can be seen as unreported precipitation events that result in a gap or a frequency reduction in values below a specific threshold. To define the small gaps, we calculated the total count of values in five precipitation ranges from 0-1, 1-2, 2-3, 3-4, and 4-5 mm (not including the values in the limits) for each year. Therefore, considering the percentage of years with zero counts:
Level 0: no small gaps (0\%; years with at least one value in any of the precipitation ranges).
Level 1: small gaps in at least 20\% of years.
Level 2: small gaps in more than 20\% of years
Argument ths present the above default thresholds for the levels definition.
}
\examples{
\dontrun{
set.seed(123)

# creating fake daily precipitation data
dates_t <- seq(as.Date("1980-01-01"), as.Date("2015-12-31"), by = "day")
prec <- round(rnorm(length(dates_t), mean = 1.2, sd = 6), 1)
prec[prec<0] <- 0
prec[prec<3 & prec>2] <- 0
xts_obj <- xts::xts(prec, dates_t)
names(xts_obj) <- "prec"

# Comparison with visual inspection
eqc_Plot(xts_obj)
eqc_SmallGaps(xts_obj)

# it also work if there is some empty data (but not if all is NA)
xts_obj["1990/2010"] <- NA
eqc_Plot(xts_obj)
eqc_SmallGaps(xts_obj)

}

}
\references{
Hunziker, S., Gubler, S., Calle, J., Moreno, I., Andrade, M., Velarde, F., ... & Brönnimann, S. (2017). Identifying, attributing, and overcoming common data quality issues of manned station observations. https://doi.org/10.1002/joc.5037

Huerta, A., Serrano-Notivoli, R., & Brönnimann, S. (2024). SC-PREC4SA: A serially complete daily precipitation dataset for South America. https://doi.org/10.31223/X57D8R
}
