//STILL TO DO:
//Improve memory allocation
//BOTTLENECK AT SPAN TREE!!!  PROBABLY AT THE UNIQUE COMMAND
#include <Rcpp.h>
using namespace Rcpp;

class connCompVec{ 
  private:
  //Stores the connected components as an integer vector... same integers designate the same connected componentss
    IntegerVector myConnComp;

  //Stores the number of connected components
    int numConnComp;
  
  //Stores the lengths of the connected components
    IntegerVector compLengths;

  public:
    connCompVec(int numNodes){
      //Initialize starting values
      myConnComp = IntegerVector(numNodes);
      numConnComp = 0;
      compLengths = IntegerVector(numNodes);
    }
  
  //Add a connected component
  void addConnComp(IntegerVector newConnComp){
    int lenConnComp = newConnComp.size();
    
    //Add the new component length
    compLengths[numConnComp] = lenConnComp;

    //Increase the number of connected components
    numConnComp++;
    
    //Add in the new connected component to the connected component vector
    for(int i = 0; i < lenConnComp; i++){
      myConnComp[newConnComp[i]-1] = numConnComp;
    }
  }

  //Return the connected component
  IntegerVector getConnComps(){
    return myConnComp;
  }
  
  //Return compnent lengths
  IntegerVector getCompLengths(){
    return compLengths;
  }
  
  //Return number of connected components
  int getNumComps(){
    return numConnComp;
  }
};

//Mimics the %in% function
LogicalVector isIn(IntegerVector vec1, IntegerVector vec2){
  return !is_na(match(vec1,vec2));
}

//Mimics ! %in% 
bool notIn(int int1, IntegerVector vec2){
  bool notIn = true;
  for(int i = 0; i < vec2.size(); i++){
    if(int1 == vec2(i)){
      notIn = false;
      break;
    }
  }
  return notIn;
}

//Mimics ! %in% 
LogicalVector notIn(IntegerVector vec1, IntegerVector vec2){
  return is_na(match(vec1,vec2));
}

//Returns TRUE indices from %in%
IntegerVector getIsIn(IntegerVector vec1, IntegerVector vec2){

  int n = vec1.size();
  IntegerVector matches = match(vec1,vec2);
  int n_out = n - sum(is_na(matches));
  IntegerVector output(n_out);
  
  for(int i = 0,j = 0;i < n; i ++){
    if(matches[i] != NA_INTEGER){
      output[j++] = vec1[i];
    }
  }		
  return output;
}

//Returns FALSE indices from %in%
IntegerVector getNotIn(IntegerVector vec1, IntegerVector vec2){
  IntegerVector matches = match(vec1,vec2);
  int n_out = sum(is_na(matches)) ;
  IntegerVector output(n_out);
		
  for(int i = 0,j = 0;i < vec1.size(); i ++){
    if(matches[i] == NA_INTEGER){
      output[j++] = vec1[i];
    }
  }	
  return output;		
}

//For printing and debugging
void printIntegerVector(IntegerVector vec1){
  for(int i = 0; i < vec1.size(); i++){
    Rcpp::Rcout << vec1[i] << " ";
  }
  Rcpp::Rcout << "\n";
}

//For printing and debugging
void printNumericVector(NumericVector vec1){
  for(int i = 0; i < vec1.size(); i++){
    Rcpp::Rcout << vec1[i] << " ";
  }
  Rcpp::Rcout << "\n";
}

void printIntegerMatrix(IntegerMatrix mat1){
  for(int i = 0; i < mat1.nrow(); i++){
    printIntegerVector(mat1.row(i));
  }
}

// Given an adjacency matrix and a subset of nodes,
//   find the connected components of the subgraph generated by the subset
connCompVec findSubsetConnComp(List adjList, IntegerVector subsetNodes, int numSubsetNodes){
  //Takes an adjacency list,
  //The vector of subset nodes
  //The number of subset nodes
						
  //initialize connCompVec
  connCompVec storeConnComp(numSubsetNodes);
   
  //Initialize visited indices
  IntegerVector visitedInd(numSubsetNodes);
  int indexVisit = 0;
  
  //Initialize connected components
  IntegerVector currConnComp(numSubsetNodes);
  int indexCurrConnComp = 0;
  
  //Add in first index if applicable.
  if(numSubsetNodes >= 1){
    visitedInd[0] = subsetNodes[0];
    currConnComp[0] = subsetNodes[0];
  }
  
  
  //While there are unassigned connected components:
  while(indexVisit <= numSubsetNodes - 1){
    
    //If visitedInd[numVisit] = 0,
    //Then no paths go from a discovered connected component to the
    //  current vertex  visited vertex numVisit.
    //Also, if we are at the last visited index, no reason to consider branches.
    //Otherwise, we branch from the current.
    
    if(visitedInd[indexVisit] != 0 && indexVisit != numSubsetNodes - 1){
      
      //find all vertices adjacent to visitedInd[indexVisit] in the complement that
      //have not been visited yet
      IntegerVector newAdjNodes = getIsIn(adjList[visitedInd[indexVisit]-1],getNotIn(subsetNodes,visitedInd));

      //Append the newAdjNodes to the current connected component, and update size of connected component
      //Initialize repeatedly used variables
      int numNew = newAdjNodes.size();
      int minVisit = 0;
      if(numNew > 0){
	minVisit = which_min(visitedInd); 
      }

      //Append
      for(int i = 0;i < numNew; i++){
	currConnComp[indexCurrConnComp + i + 1] = newAdjNodes[i];
	visitedInd[minVisit + i] = newAdjNodes[i];
      }

      //Update connected component size
      indexCurrConnComp = indexCurrConnComp + numNew;
      indexVisit++;
      
    }
    else{

      //Store current connected component
      //The match function ensures that the connected component indices corresponds to numbers between
      //1 and numSubsetNodes
      storeConnComp.addConnComp(match(currConnComp[seq(0,indexCurrConnComp)],subsetNodes));
      
      //If we need to create a new connected component...
      //if(indexVisit < numSubsetNodes - 1 || 
      if(visitedInd[indexVisit] == 0){
	
	//Create a new visited node
	//and a new connected component
	
	//Finds the first subsetNode that does not correspond to a visited index
	visitedInd[indexVisit] = getNotIn(subsetNodes,visitedInd)[0];
	
	//Create new connected component
	currConnComp[0] = visitedInd[indexVisit];

	//Update connected component index
	indexCurrConnComp = 0;

      }
      else{
	//If not, we need to terminate the algorithm by increasing indexVisit... 
	indexVisit++;
      }
    }
  }
  
  return storeConnComp;	
}

connCompVec findComplementConnComp(List adjList, IntegerVector compNodes){
  int n = adjList.size();
  int nomit = n - compNodes.size();
  return findSubsetConnComp(adjList, getNotIn(seq(1,n),compNodes),nomit);
}

bool is2con(List adjList){

  //Initialize
  bool is2con = true;
  IntegerVector vec1(1);
  int adjSize = adjList.size();

  for(int i = 0; i < adjSize; i++){

    //Increment vec1
    vec1[0] = i+1;

    //Get connected components of vector complement of vec1
    connCompVec myConnComp = findComplementConnComp(adjList,vec1);

    //If the complement connected component has more than one element, 
    //set is2con = false and break loop.
    if(myConnComp.getNumComps() > 1){
      is2con = false;
      break;
    }
  }
  
  //Return
  return is2con;
} 

// IntegerMatrix uniqueRows(IntegerMatrix intMat){

//   //NOTE! FASTER THAN R!
//   //Store rows and columns
//   int numNrow = intMat.nrow();
//   int numNcol = intMat.ncol();

//   //Initialize unique row matrix
//   IntegerMatrix newMat(numNrow,numNcol);
//   newMat.row(0) = intMat.row(0);

//   //Stores the index of the current row
//   int j = 1;
  
//   //Tests uniqueness:
//   bool isUniq = true;

//   //See if current row matches all entries of a previous matrix
//   for(int i = 1; i < numNrow; i++){
//     for(int k = 0; k < j; k++){
//       for(int l = 0; l < numNcol; l++){
// 	//If we have any inequality, stop this check
// 	if(intMat(i,l) != newMat(k,l)){
// 	  break;
// 	}
// 	//If we have perfect equality than this row is not unique
// 	if(l == numNcol -1){
// 	  isUniq = false;
//       	}
//       }

//       //If we do not have uniqueness, stop checking for this row
//       if(!isUniq){
// 	break;
//       }
//     }

//     //If this row is unique, add it
//     if(isUniq){
//       newMat.row(j++) = intMat.row(i);
//     }

//     //Reset isUniq
//     isUniq = true;

//   }
//   return newMat(seq(0,j -1),seq(0,numNcol-1));
// }

bool notInList(IntegerVector intVec, List myList){

  //Store length of intVec and size of myList
  int lenIntVec = intVec.size();
  int lenMyList = myList.size();
  
  //Tests uniqueness:
  bool isUniq = true;

  //See if vector matches all entries of a previous list entry
  for(int i = 0; i < lenMyList; i++){

    //Temporarily store ith component of the list
    IntegerVector tempIntVec = myList[i];


    //If the component is of the right size...
    if(tempIntVec.size() == lenIntVec){
      
      //Examine each entry of intVec
      for(int j = 0; j < lenIntVec; j++){
	
	//If we have inequality, stop this check
	if(intVec[j] != tempIntVec[j]){
	  break;
	}

	//If we have perfect equality, then this row is not unique
	if(j == lenIntVec - 1){
	  isUniq = false;
	}	
      } 
    }
    //If not unique, break
    if(!isUniq){
      break;
    }
  }

  return isUniq;
}

class spanTree{ 
  private:
  //Stores adjacency list
    List spanAdjList;
  
  //Stores list of invalid nodes for building the spanning tree
    List invalidNodes;

  //Stores list of exhausted nodes for building the spanning tree
    List exhaustedNodes;

  //Stores list of last-added nodes for building the spanning tree
    IntegerVector lastAdded;

  //Stores the population size for each node
    NumericVector myPopSizes;
    
  //Stores the current spanning tree
    List mySpanTree;
  
  //Stores the length of the adjacency list
    int adjListLength;
  
  //Stores the current depth of the spanning tree
    int currDepth;
  
  //Stores the count of the component in the spanning tree       
    int countCurrSpan;

  //Stores connected components: one for each row of the spanning tree
    IntegerMatrix connComps;

  //Stores complement connnected component lengths: one for each row of the spanning tree
    List compConnCompLengths;
  
  //Stores population sums for each connnected component: one for each row of the spanning tree
    List connCompPopSums;

  //Stores sizes of connected components
    IntegerVector numConnComps;

  //Stores 2-connectedness
    bool is2conB;
  
  //MIKE: Changing spanTree!
  //      Changing connComps
  //      Changing compConnCompLengths
  //      Changing connCompPopSums
  //      Changing numConnComps to need push.back, push.forward
  public:
  spanTree(List adjList, NumericVector popSizes){
     
      //Get length of adjacency list
      adjListLength = adjList.size();

      //Initialize starting values
      spanAdjList = adjList;
      myPopSizes = popSizes;
      mySpanTree = List();
      lastAdded = IntegerVector();
      currDepth = 0;
      countCurrSpan = 0;
      connComps = IntegerMatrix();
      compConnCompLengths = List();
      connCompPopSums = List();
      numConnComps = IntegerVector();
      is2conB = is2con(adjList);
    }
  
  //Grow a spanning tree
  void growSpanTree(){    

    //Store old value of countcurrSpan and
    //Reset countCurrSpan
    int oldCountCurrSpan = countCurrSpan;
    countCurrSpan = 0;
    
    //If we have yet to grow:
    if(currDepth == 0){

      //Initialize a node.
      IntegerVector tempInt(1);
      IntegerVector tempInt2(1);
      tempInt[0] = 1;
      mySpanTree.push_back(tempInt);
      lastAdded.push_back(1);
      invalidNodes.push_back(tempInt2);
      exhaustedNodes.push_back(tempInt2);
      countCurrSpan++;
      
    }
    else{
      // Rcpp::Rcout << "def a raizin: " << oldCountCurrSpan << "\n";
      
      // for(int k = 0; k < mySpanTree.size(); k++){
      // 	printIntegerVector(mySpanTree(k));
      // 	printIntegerVector(invalidNodes(k));
      // 	printIntegerVector(exhaustedNodes(k));

      // }

      // Rcpp::Rcout << "raizin\n";
      for(int i = 0; i < oldCountCurrSpan; i++){
	
	//New idea, push new nodes to the back of the spanning tree, and erase once
	//to remove old nodes

	//Initialize whether we write over a current member of mySpanTree
	//Moreover, p = 0 denotes no exploration
	//int p = 0;

	//Initialize whether current branch of the spanning tree has any adjacent unexplored nodes
	//int q = 0;

	//Obtain an entry of the spanning tree. 
	IntegerVector rowSpan = mySpanTree(i);

	//Obtain invalid nodes and exhausted nodes: 
	IntegerVector invNod = invalidNodes(i);
	IntegerVector exhNod = exhaustedNodes(i);
	
	// if(rowSpan.size() == 5){
	//   Rcpp::Rcout << "Start, lastAdded: "<<lastAdded[i]<<"\n";
	//   printIntegerVector(rowSpan);
	//   printIntegerVector(invNod);
	//   printIntegerVector(exhNod);
	// }
	// printIntegerVector(rowSpan);
	// printIntegerVector(invNod);
	// printIntegerVector(exhNod);
	//Create a temporary row where the first currDepth elements are rowSpan
	IntegerVector tempRowSpan(currDepth+1);
	
	for(int j = 0; j < currDepth; j++){
	  tempRowSpan[j] = rowSpan[j];
	}

	//Create a temporary visitor integer vector
	IntegerVector tempVisit = clone(invNod);

	//Travel to new unique nodes from each node in rowSpan.
	for(int j = 0; j < currDepth; j++){
	  
	  //If j has not been exhausted yet
	  if(notIn(rowSpan[j],exhNod)){
	    
	    int rowSpanSize = rowSpan.size();
	    int tempVisitSize = tempVisit.size();

	    //Create vector comprised of rowSpan and tempVisit
	    IntegerVector intvec(rowSpanSize + tempVisitSize);
	    for(int z = 0; z < rowSpanSize + tempVisitSize; z++){
	      if(z < rowSpan.size()){
		intvec[z] = rowSpan[z];
	      }
	      else{
		intvec[z] = tempVisit[z - rowSpanSize];
	      }
	    }
	    //Find nodes not adjacent to j not yet travelled to,
	    //And that are valid
	    IntegerVector notTravelled = getNotIn(spanAdjList[rowSpan[j]-1],intvec);
	    
	    // Rcpp::Rcout << "Not Travelled: \n";
	    // printIntegerVector(notTravelled);
	    if(notTravelled.size() == 0){
	      //If nothing to travel to,
	      //Add node rowSpan[j] as an exhausted node
	      // Rcpp::Rcout << "Here\n";
	      exhNod.push_back(rowSpan[j]);
	    }
	    else{
	      // Rcpp::Rcout << "THere\n";

	      //Sort notTravelled... priority to lowest ordered
	      notTravelled.sort();
		
	      //Create new branches of the spanning tree
	      for(int k = 0; k < notTravelled.size(); k ++){		  

		//Add a new unique adjacent node to tempRowSpan
		tempRowSpan[currDepth] = notTravelled[k];

		//Sort tempRowSpan 
		IntegerVector tempSortRow = clone(tempRowSpan);
		tempSortRow.sort();
	    
		bool okToAdd = true;
		//Check whether maximum in rowSpan is bigger than proposed added node:
		//if(max(rowSpan) > notTravelled[k]){
		  
		  //If so, 
		//check uniqueness.
		for(int r = oldCountCurrSpan; r < oldCountCurrSpan+countCurrSpan; r++){
		  IntegerVector temptem = mySpanTree[r];

		  for(int s = 1; s < currDepth+1; s++){
		    if(tempSortRow[s] != temptem[s]){
		      break;
		      }
		    if(s == currDepth){
		      okToAdd = false;
		    }
		  }
		  if(!okToAdd){
		    break;
		  }
		
		  // okToAdd =  notInList(tempSortRow,mySpanTree(seq(oldCountCurrSpan,countCurrSpan-1));
		  
		}

		if(okToAdd){   
				  
		  //printIntegerVector(tempRowSpan);
		  //Clone invNod and exhNod
		  IntegerVector cInvNod = clone(invNod);
		  IntegerVector cExhNod = clone(exhNod);

		  
		  //If k = notTravelled.size(), then current node is exhausted is exhausted
		  if(k == notTravelled.size()-1){
		    cExhNod.push_back(rowSpan[j]);
		  }

		  //Add nodes:
		  mySpanTree.push_back(tempSortRow);
		  invalidNodes.push_back(cInvNod);
		  exhaustedNodes.push_back(cExhNod);
		  lastAdded.push_back(notTravelled[k]);
		  countCurrSpan++;

		  // Rcpp::Rcout << "AftaAddin: \n";
		  // printIntegerVector(tempSortRow);
		  // printIntegerVector(cInvNod);
		  // printIntegerVector(cExhNod);
		  // Rcpp::Rcout << "dun: \n";
		    
		  //Node notTravelled[m] seen... can add to invalid nodes...
		  //too strong invNod.push_back(notTravelled[k]);
		  tempVisit.push_back(notTravelled[k]);
		}
	      }
	    }
	  } 
	}
      }
      //Rcpp::Rcout << "erasin: " << oldCountCurrSpan << "\n";
      
      //Erase redundant things:
      mySpanTree.erase(0,oldCountCurrSpan);
      invalidNodes.erase(0,oldCountCurrSpan);
      exhaustedNodes.erase(0,oldCountCurrSpan);
      lastAdded.erase(0,oldCountCurrSpan);
      //Rcpp::Rcout << "size: "<< lastAdded.size()<<" count: " << countCurrSpan << "\n";
      // for(int k = 0; k < mySpanTree.size(); k++){
      // 	//printIntegerVector(mySpanTree(k));
      // 	//printIntegerVector(invalidNodes(k));
      // 	//printIntegerVector(exhaustedNodes(k));
      // 	//printIntegerVector(lastAdded);
      // }

      // Rcpp::Rcout << "Dun eraz\n";
    }
    //Increase current depth
    currDepth++;

  }

  //Generate connected components
  void genConnCompsSpanTree(){
    
    //Initialize connComps integer matrix, numConnComps integerVector
    //and compConnCompLengths List
    
    connComps = IntegerMatrix(countCurrSpan,adjListLength);
    numConnComps = IntegerVector(countCurrSpan);
    compConnCompLengths = List(countCurrSpan);

    //Stores connected component to make the complement.
    IntegerVector compVector(currDepth);
    
    //Stores complement connected component lengths.
    //IntegerVector myCompConnCompLengths(currDepth);
    
    //Stores the number of connected components
    //int myNumComps = 0;
    for(int i = 0; i < countCurrSpan; i++){
      
      //Obtain connected component from the spanning tree
      IntegerVector compVector = mySpanTree(i);
      
      //printIntegerVector(compVector);
      //Find complement connected components
      connCompVec myCompConnComp = findComplementConnComp(spanAdjList,compVector);
      
      //Store a connected component 
      IntegerVector tempConnComp = myCompConnComp.getConnComps();

      //Determine whether each node corresponds to the original 
      //row in the spanning tree or a node in the complement connected component
      //If original spanning tree... set as one
      for(int j = 0, k = 0, l = 0; j < adjListLength; j++){
	if(compVector[k] - 1 == j && k < compVector.size()){
	  connComps(i,j) = 1;
	  k++;
	}

	//Otherwise, use the value in the complement connected component
	else{
	  connComps(i,j) = tempConnComp[l] + 1;
	  l++;
	}
      }

      //Store the number of components
      numConnComps[i] = myCompConnComp.getNumComps() + 1;

      //Get the complement connected component lengths
      compConnCompLengths(i) = myCompConnComp.getCompLengths();

    }
  }
  
  //Find population sizes for each connected component
  void findPopSizesConnComp(){
    
    //Initialize List connCompPopSums
    connCompPopSums = List(countCurrSpan);
    
    //Every row
    for(int i = 0; i < countCurrSpan; i++){
      
      //Initialize a population sums connected component numeric vector
      NumericVector somePopSums(numConnComps[i]);

      //Every component in the sum
      for(int j = 0; j < adjListLength; j++){
	
	//Add popSize to the corresponding component
	somePopSums(connComps(i,j)-1) += myPopSizes[j];     
      }
      
      connCompPopSums(i) = somePopSums;
    }
  }

  //Remove branches of the spanning tree
  //WARNING: DOES NOT ADJUST COMPLEMENT CONNECTED COMPONENTS
  void removeSpanTree(LogicalVector isValid){
    int mySum = sum(isValid);

    //Don't do anything if all are valid:
    if(mySum < countCurrSpan){
      
      //Create a new list:
      List oldList = clone(mySpanTree);
      List oldList2 = clone(invalidNodes);
      List oldList3 = clone(exhaustedNodes);
      
      //Create a new IntegerVector
      IntegerVector oldLastAdded = clone(lastAdded);
      //Rprintf("oldsize: %d, countCurrSpan: %d, mySum: %d\n",oldList.size(), countCurrSpan, mySum);
      
      //Instantiate mySpanTree
      mySpanTree = List(mySum);
      invalidNodes = List(mySum);
      exhaustedNodes = List(mySum);
      lastAdded = IntegerVector(mySum);

      for(int i = 0, j = 0; i < countCurrSpan; i++){   
	if(isValid[i] == true){

	  mySpanTree(j) = oldList(i);
	  invalidNodes(j) = oldList2(i);
	  exhaustedNodes(j) = oldList3(i);
	  lastAdded(j) = oldLastAdded(i);

	  j++;
	}
      }
      
      //Update countCurrSpan
      countCurrSpan = mySum;
    }
  }
  

 //Functions to return important quantities
  int getCurrDepth(){
    return currDepth;
  }

  int getCountCurrSpan(){
    return countCurrSpan;
  }

  IntegerVector getSpanTree (int index){
    IntegerVector tempSpanRow = mySpanTree(index);
    return tempSpanRow;
  }

  IntegerVector getConnComps (int index){
    IntegerVector tempConnComps = connComps.row(index);
    //Rcpp::Rcout << "Inside the makers mark stewdio: ";
    //printIntegerVector(tempConnComps);
    return tempConnComps;
  }  

  int getNumConnComps(int index){
    return numConnComps[index];
  }
  
  NumericVector getConnCompPopSums(int index){
    NumericVector tempConnCompPopSums = connCompPopSums(index);
    return tempConnCompPopSums;
  }

  IntegerVector getCompConnCompLengths(int index){
    IntegerVector tempCompConnCompLengths = compConnCompLengths(index);
    return tempCompConnCompLengths;
  }  

  bool get2con(){
    return is2conB;
  }

  void allGrow(){
    growSpanTree();
    // Rcpp::Rcout<<"growed \n";
    // Rcpp::Rcout<<"CountCurrSpan: "<<countCurrSpan<<"\n"; 
    // for(int i = 0; i < countCurrSpan; i++){
    //   printIntegerVector(mySpanTree(i));
    // }
    // Rcpp::Rcout<<"CountCurrSpan: "<<countCurrSpan<<"\n"; 
    genConnCompsSpanTree();
    // Rcpp::Rcout<<"comps \n";
    findPopSizesConnComp();
    // Rcpp::Rcout<<"sizes \n";
    //    Rprintf("countcurrspan: %d\n", countCurrSpan);
    //Rcpp::Rcout << "Diagnostics: " << mySpanTree.size() << " " << connComps.nrow() << " " << compConnCompLengths.size() << "\n";
  }

  void printSpan(){
    for(int i = 0; i < countCurrSpan; i++){
      printIntegerVector(mySpanTree(i));
      printIntegerVector(invalidNodes(i));
      printIntegerVector(exhaustedNodes(i));
      // Rcpp::Rcout << numConnComps(i) << " " << countCurrSpan << " "<<  "\n";
    }
  }
};

//List testSpan(List adjList, NumericVector popSizes){
void testSpan(List adjList, NumericVector popSizes){

  spanTree tempSpan(adjList,popSizes);
  tempSpan.allGrow();
  Rprintf("Test1\n");
  tempSpan.allGrow();
  Rprintf("Test2\n");

  tempSpan.allGrow();
  Rprintf("Test3\n");
  tempSpan.allGrow();
  Rprintf("Test4\n");
  tempSpan.printSpan();

  tempSpan.allGrow();
  Rprintf("Test5\n");
tempSpan.allGrow();
  Rprintf("Test6\n");
  tempSpan.printSpan();
  Rcpp::Rcout << "COUNT: " << tempSpan.getCountCurrSpan() << "\n";
  // tempSpan.allGrow();

  // Rprintf("Test6\n");
  // tempSpan.allGrow();
  // Rprintf("Test7\n");
  // tempSpan.allGrow();
  // Rprintf("Test8\n");
  // tempSpan.allGrow();
  // Rprintf("Test9\n");
  // tempSpan.allGrow();
  // Rprintf("Test10\n");
  // tempSpan.allGrow();
  // Rprintf("Test11\n");
  // tempSpan.allGrow();
  // Rprintf("Test12\n");
  // tempSpan.allGrow();
  // Rprintf("Test13\n");
  // tempSpan.allGrow();
  // Rprintf("Test14\n");
  // tempSpan.allGrow();
  // Rprintf("Test15\n");

  // List newlist;
  // for(int i = 0; i < tempSpan.getCountCurrSpan(); i++){
  //   if(tempSpan.getNumConnComps(i) == 2){
  //     newlist.push_back(tempSpan.getConnComps(i));
  //   }
  // }

  // return newlist;
}

//Test the new span tree
void testSpan3(List adjList, NumericVector popSizes){
  spanTree tempSpan(adjList,popSizes);
  tempSpan.allGrow();
  Rcpp::Rcout << "Test1";
  tempSpan.allGrow();
  Rcpp::Rcout << "Test2";
  tempSpan.allGrow();
  Rcpp::Rcout << "Test3";
  tempSpan.allGrow();
  Rcpp::Rcout << "Test4";
  tempSpan.allGrow();
  Rcpp::Rcout << "Test5";
  tempSpan.allGrow();
  Rcpp::Rcout << "Test6";
  tempSpan.allGrow();
  Rcpp::Rcout << "Test7";
  tempSpan.printSpan();
  tempSpan.allGrow();
  Rcpp::Rcout << "Test8";
  tempSpan.printSpan();
  tempSpan.allGrow();
  Rcpp::Rcout << "Test9";
  tempSpan.printSpan();
  
}

//Test the new span tree
void testSpan2(List adjList, NumericVector popSizes){
  spanTree tempSpan(adjList,popSizes);
  tempSpan.allGrow();
  Rcpp::Rcout << "Test1";
  tempSpan.printSpan();
  tempSpan.allGrow();
  Rcpp::Rcout << "Test2";
  tempSpan.printSpan();
  tempSpan.allGrow();
  Rcpp::Rcout << "Test3";
  tempSpan.printSpan();
  tempSpan.allGrow();
  Rcpp::Rcout << "Test4";
  tempSpan.printSpan();  
  tempSpan.allGrow();
  Rcpp::Rcout << "Test5";
  tempSpan.printSpan();
  tempSpan.allGrow();
  Rcpp::Rcout << "Test6";
  tempSpan.printSpan();
  tempSpan.allGrow();
  Rcpp::Rcout << "Test7";
  tempSpan.printSpan();
  tempSpan.allGrow();
  Rcpp::Rcout << "Test8";
  tempSpan.printSpan();
  tempSpan.allGrow();
  Rcpp::Rcout << "Test9";
  tempSpan.printSpan();
  
}

List createSubsetAdjList(List adjList, IntegerVector subsetNodes){

  //Initialize
  int sizeList = subsetNodes.size();
  List newAdjList(sizeList);
  
  for(int i = 0; i < sizeList; i++){
    
    //Find the set of vertices in adjList that correspond to subsetNodes[i],
    //Only include those that are in subsetNodes
    //And use match to get a vector with numbers between 1 and sizeList
    newAdjList[i] = match(getIsIn(adjList[subsetNodes[i] - 1], subsetNodes),subsetNodes);
  }

  return newAdjList;
}

bool checkAllGeq(NumericVector vec1, double numb){
  bool tempbool = true;
  for(int j = 0; j < vec1.size(); j++){
    if(vec1[j] < numb){
      tempbool = false;
      break;
    }
  }
  return tempbool;
}

bool checkAllLeq(NumericVector vec1, double numb){
  bool tempbool = true;
  for(int j = 0; j < vec1.size(); j++){
    if(vec1[j] > numb){
      tempbool = false;
      break;
    }
  }
  return tempbool;
}

//Straight from R
IntegerVector nextSample(IntegerVector currSample){

  //Initialize
  int enn = sum(currSample);
  int len = currSample.size();  
  int nl = enn+len;
  int j = 0;
  IntegerVector newConfig(len+1);
  newConfig[len] = 1;
  int tempSum = 0;
  for(int i = 0; i < len; i++){
    tempSum += currSample[i]+1;
    newConfig[i] = tempSum;
  }
  bool done = false;
  bool a = false;
  
  //If length is 1, don't do anything.
  if(len == 1){
    a = true;
    done = true;
  }

  while(!a){
    if(newConfig[j] + 1 == newConfig[j+1]){
      newConfig[j] = j+1;
      j = j+1;
      if(j == len - 1){
	a = true;
	done = true;
      }
    }
    else{
      newConfig[j] = newConfig[j] + 1;
      a = true;
    }
  }

  newConfig[len-1] = nl;
  newConfig[len] = 0;
  newConfig = newConfig.sort();

  if(done){
    currSample[0] = -1;
  }
  else{
    for(int i = 0; i < len; i++){
      currSample[i] = newConfig[i+1] - newConfig[i]-1; 
    }
  }
  
  return currSample;
}

//Generate all ways of allocating numb balls to k urns, where each urn u can hold l_u balls.
//CHANGING THIS TO A LIST
List generateAllocations(int numb, IntegerVector capacity, int myNumHigh, IntegerVector myCompConnCompLengths){

  //Store the index of allocations
  int indexAlloc = 0;
  
  //Store the length of capacity
  int caplen = capacity.size();

  //Initialize all allocations
  List allAllocs;
  
  //Store non-zero capacities
  IntegerVector nonZeroCap(caplen);

  //Count non-zero capacities
  int countNonZero = 0;
  
  //Find which capacities are nonzero:
  for(int i = 0; i < caplen; i ++){
    if(capacity[i] > 0){
      nonZeroCap[countNonZero++] = i;
    }
  }
  
  //Reduce the sample to non-zero entries.
  IntegerVector storeSample(countNonZero); 
  
  //Initialize storeSample
  storeSample[countNonZero-1] = numb; 
  
  //While we still look for additional allocations
  while(storeSample[0] != -1){

    //Initialize a boolean to help determine whether to add an alloc to allAllocs
    bool toadd = true;

    //Check to see if the current proposed allocation is valid
    for(int i = countNonZero-1; i >= 0; i--){
      if(storeSample[i] > capacity[nonZeroCap[i]]){
  	toadd = false;
  	break;
      }
      if(storeSample[i] == 0 && myCompConnCompLengths[nonZeroCap[i]] > myNumHigh){
	toadd = false;
  	break;
      }
    }
    
    //If we add the allocation:
    if(toadd){
      IntegerVector tempAdd(caplen);
      for(int i = 0; i < countNonZero; i++){
  	tempAdd(nonZeroCap[i]) = storeSample[i];
      }

      allAllocs.push_back(tempAdd);
      
      //Increment indexAlloc
      indexAlloc++;
    }

    //Find the next sample
    storeSample = nextSample(storeSample);
  }

  return allAllocs;
  
}

//Works like expand.grid
IntegerMatrix expandGrid(IntegerVector capacity){

  //Store the length of capacity
  int caplen = capacity.size();
  
  //Capacities
  IntegerVector myCaps(caplen);
  
  //Take product of capacities:
  int prod = 1;
  
  for(int i = 0; i < caplen; i++){
    prod = prod*(capacity[i]+1);
  }

  //Store capacities
  IntegerMatrix myExpandGrid(prod, caplen);

  //Initialize.  Set gridIndex = 1 to set first row = 0,0
  int width = 0;
  int gridIndex = 1;
  
  //initialize expand grid
  while(width < caplen){
    if(myCaps[width] == capacity[width]){
      myCaps[width] = 0;
      width = width + 1;      
    }
    else{
      myCaps[width] = myCaps[width] + 1;
      width = 0;
          
      for(int i = 0; i < caplen; i++){
	myExpandGrid(gridIndex,i) = myCaps[i];
      }
      gridIndex++;
    }
  }

  return myExpandGrid;
}

IntegerVector findUpperAllocs(int myNumConnComps, int myNumLow, int myNumHigh, IntegerVector myCompConnCompLengths){
  
  //numPartConnComps will determine where we can allocate
  IntegerVector numPartConnComps(myNumConnComps - 1);
    
  //Generate all ways to create diffBlocks more blocks by further partitioning connected components.
  //First, see how many blocks of size at least myNumLow can be created within each connected component.  
  for(int j = 0; j < myNumConnComps-1; j++){
      
    //Eliminate case where divide by zero
    if(myNumLow == 0){
    	
      numPartConnComps[j] = myCompConnCompLengths[j];
    }
    else{
      double qt = myCompConnCompLengths[j]/(double)myNumLow;
      numPartConnComps[j] = (int)floor(qt);
    }
    if(numPartConnComps[j] >= 1){
      if(numPartConnComps[j] == 1 && myCompConnCompLengths[j] > myNumHigh){
	numPartConnComps[j] = -1;
      }
     else{
        //Subtract 1 to get additional blocks to be produced
        numPartConnComps[j]--;
     }
    } 
  }

  return numPartConnComps;
}

//Used to call generateAllocations, or return a List with a zero entry if
//nowhere to expand.
 List doGenerateAllocations(IntegerVector numPartConnComps, int diffBlocks, bool canExpand, int myNumHigh, IntegerVector myCompConnCompLengths){
    
  //Initialize integer matrix
  if(canExpand){
    
    //Return the result from generateAllocations
    return generateAllocations(diffBlocks,numPartConnComps, myNumHigh, myCompConnCompLengths);

  }
  else{
    //STILLNEEDTOEDIT
    return List(0);
      //IntegerMatrix(1,1);
  }
}

//Only run if something can be split
class partitionIterator{ 
  private:

  //Store all the inputs
  List myAdjList;
  int myNumBlocks;
  NumericVector myPopSizes;
  int myNumLow;
  int myNumHigh;
  IntegerVector myConnComp;
  int myNumConnComps;
  IntegerVector myCompConnCompLengths;
  
  //make a myAdjListLength variable
  int myAdjListLength;
  
  //Useful in referring to the connected component
  IntegerVector referConnComp;

  //Useful in referring to the number of subblocks to be divided
  IntegerVector referNumSubBlock;

  //Useful in referring to the modified adjacency list
  IntegerVector referAdjList;
  
  //Stores connected component vectors
  List listConnComps;

 //Stores pop sizes
  List listPopSizes;

  //Stores modified adjacency lists
  List modifiedAdjList;
  
  //Stores new numConstraint Highs
  IntegerVector newNumConsHigh;

  //For unique storage
  int uniqueStorage; 

  //Stores results from generatePartitions
  List partitionMatList;
  
  //Stores whether a partition from generatePartitions is valid or not
  IntegerVector isValidPartitionMatList;

  //Stores the number of partitions to store
  //Looks useless
  //int numParts;
  
  //Stores results form generateAllocations
  IntegerMatrix myAlloc;

  //Stores the number of blocks that need to be allocated
  int diffBlocks;
  
  //Stores the number of blocks that can be allocated within each connected component
  IntegerVector numPartConnComps;

  //Indicates whether we can fit diffComps blocks into the remaining connected components
  bool canExpand;

  //Stores valid allocs matrix
  List validAllocs;
  
  //Stores partitions to add to cppGeneratePartitions
  List tempGenParts;
  
  //aConnComp, numConnComps, and compConnCompLengths come from a
  //connected component object
  public:
  partitionIterator(List adjList, int numBlocks, NumericVector popSizes, int numConstraintLow, int numConstraintHigh, IntegerVector aConnComp, 
		    int numConnComps, IntegerVector compConnCompLengths){

    //Initialize starting values
    //First, those directly in the function
    myAdjList = adjList;
    myNumBlocks = numBlocks;
    myPopSizes = popSizes;
    myNumLow = numConstraintLow;
    myNumHigh = numConstraintHigh;
    myConnComp = aConnComp;
    myNumConnComps = numConnComps;
    myCompConnCompLengths = compConnCompLengths;
        
    //Now, ones that are not
    myAdjListLength = myAdjList.size();
    //HEY!
    referConnComp = IntegerVector();
    //HEY
    referNumSubBlock = IntegerVector();
    //HEY
    referAdjList = IntegerVector();
    //
    listConnComps = List();
    //HEY
    listPopSizes = List();
    //HEY
    modifiedAdjList = List();
    //HEY
    newNumConsHigh = IntegerVector();
    //HEY
    isValidPartitionMatList = IntegerVector();
    uniqueStorage = 0;
    //HEY
    partitionMatList = List();
    //looks useless
    //numParts = 0;
    diffBlocks = myNumBlocks - myNumConnComps;
    numPartConnComps = findUpperAllocs(myNumConnComps, myNumLow, myNumHigh, myCompConnCompLengths);

    //You can expand to make a valid partition if the number of extra components in numPartConnComps is 
    //atleast diffBlocks
    canExpand = (bool)(sum(numPartConnComps) >= diffBlocks && min(numPartConnComps >= 0) );
    //HEY, NOW A LIST!
    validAllocs = doGenerateAllocations(numPartConnComps, diffBlocks, canExpand, myNumHigh, myCompConnCompLengths);
 
    //HEY! NOW A LIST!
    tempGenParts = List();
  }
  
  //Prepare to add connected components for each Add a connected component
  void prepareNewPartitions(){

    //What is the fewest number of partitions we need to recursively generate?
    //For each node, obtain the corresponding column of validAllocs, and pluck off 
    //Non-zero unique entries.  
    //i is node
    //j is component
    //l is unique elements
    //m denotes the first index within a component 

    for(int i = 0, j = -1, m = 0; i < myNumConnComps-1; i++){
      
      IntegerVector tempAllocCol2(validAllocs.size());
      for(int k = 0; k < validAllocs.size(); k++){
	IntegerVector intVec = validAllocs(k);
	tempAllocCol2[k] = intVec[i];
      }
      IntegerVector tempAllocCol = sort_unique(tempAllocCol2);
   
      //k searches elements of tempAllocCol
      for(int k = 0; k < tempAllocCol.size(); k++){
	
	//If there is something to add
	if(tempAllocCol[k] > 0){

	  //If it's the first time visiting this guy, 
	  //and there is at a possibility for splitting this block, 
	  //add a modified adjacency list
	  if(m == 0 ){
	    
	    //Increment component
	    j++;

	    //Generate an IntegerVector that will store which nodes correspond to
	    //the tempRef component
	    IntegerVector connCompRef(myCompConnCompLengths[i]);
	    NumericVector popSizesRef(myCompConnCompLengths[i]);
	    
	    //If the node corresponds to the tempRef component, add that node to connCompRef
	    for(int r = 0, s = 0; r < myAdjListLength; r++){

	      if(myConnComp[r] == i+2){
		connCompRef[s] = r+1;
		popSizesRef[s] = myPopSizes[r];
		s++;
	      }
	    }
	          
	    //Add the connected component to listConnComps
	    //And the popSizes to listPopSizes
	    listConnComps.push_back(connCompRef);
	    listPopSizes.push_back(popSizesRef);

	    //Add the modified adjacency list to the list object
	    modifiedAdjList.push_back(createSubsetAdjList(myAdjList, connCompRef));
	  }

	  //Update references
	  referConnComp.push_back(i+2);
	  referNumSubBlock.push_back(tempAllocCol[k]);
	  referAdjList.push_back(j);

	  //For a partition that requires the construction of z more blocks
	  //The max for any block is myCompConnCompLenths[i] - numConstraintLow*(z)
	  if(myNumHigh >  myCompConnCompLengths[i] - myNumLow*tempAllocCol[k]){

	    newNumConsHigh.push_back(myCompConnCompLengths[i] - myNumLow*tempAllocCol[k]);
	  }
	  else{

	    newNumConsHigh.push_back(myNumHigh);
	  }

	  //Increment UniqueStorage
	  uniqueStorage++;

	  //increment m
	  m++;
	  
	  
	}
      }
      
      //Reset m
      m = 0;
    }
  } 

  //Get number of unique partitions to generate
  int getNumberIterations(){
    return uniqueStorage;
  }
  
  //Get updated adjacency list
  List getNewAdjList(int index){
    
    //Return the subset Adjacency list
    //for the component that corresponds to that index
    return modifiedAdjList[referAdjList[index]];
  } 

  //Get new number of blocks
  int getNewNumBlocks(int index){

    //Return the blocksizes
    //for the component that corresponds to that index
    //Add one since variable measures number of additional blocks
    return referNumSubBlock[index] + 1;
  }
  
  //Get new number of blocks
  int getReferAdjList(int index){

    //Return the blocksizes
    //for the component that corresponds to that index
    //Add one since variable measures number of additional blocks
    return referAdjList[index];
  }

  //Get new pop sizes
  NumericVector getNewPopSizes(int index){
    
    return listPopSizes[referAdjList[index]];
  }
  
  //Get new numConstraintHigh
  int getNewNumConstraintHigh(int index){

    //Return the numConstraintHighs
    //for the component that corresponds to that index
    return newNumConsHigh[index];
  }
  
  void storePartition(List storePart){
    //Looks useless
    //printIntegerMatrix(storePart);
    //Check whether the stored partition is valid

    if(storePart.size() != 0){
      isValidPartitionMatList.push_back(1); 
    }
    else{
      isValidPartitionMatList.push_back(0);
    }
    //printIntegerMatrix(storePart);

    //Store the partition and increment numParts
    partitionMatList.push_back(storePart);

    //numParts++;
    
  }
  
  //Combine blocks to obtain partitions to add to the number of partitions
  void combinePartitions(){

    //Variables to consider
    //Need something to store which uniqueIndices things correspond to
    //Need something to indicate whether the component is 0 or 1
    //Need something to count the number of components
    //and something to say whether the row of validAllocs will lead to a valid partitoin
    IntegerVector uniqCorrInd(myAdjListLength);
    IntegerVector isNonZero(myAdjListLength);
    int numNonZero = 0;
    bool didBreak = false;
  
    //For each row of validAllocs
    for(int i = 0; i < validAllocs.size(); i++){

      //Reset numNonzero and did break
      numNonZero = 0;
      didBreak = false;

      IntegerVector aTempInt = validAllocs(i);

      //For each column of validAllocs
      //(each column corresponds to a node - 2)
      for(int j = 0; j < aTempInt.size(); j++){
	
	//If nonzero...
	if(aTempInt(j) > 0){
	  
	  //Update isNonZero
	  isNonZero[j] = 1;

	  //Find the unique index that corresponds to this value
	  for(int k = 0; k < uniqueStorage; k++){
	    if(referConnComp[k] == j+2 && referNumSubBlock[k] == aTempInt(j)){
	      
	      //Check Validity of the partition
	      if(isValidPartitionMatList[k] == 0){
		
		//If invalid, set didbreak = true
		didBreak = true;
	      }

	      //Otherwise, store uniqueCorrInd and increment numNonZero
	      else{
		uniqCorrInd(numNonZero++) = k;
	      }
	      
	      //Break out of this for loop regardless
	      break;
	    }
	  }
	}

	//Otherwise, is zero
	else{
	  isNonZero[j] = 0;
	}
	
	//If we have didBreak true, break out of this loop
	if(didBreak){
	  break;
	}
      }
      
      //If we didn't break, then generate extra partitions to store into cppGeneratePartitions
      if(!didBreak){
	
	//Handle case with only one nonzero and many nonzero separately
	if(sum(isNonZero) == 1){
	  
	  //Store this guy quick
	  //NOW a list!
	  List quickStore = partitionMatList[uniqCorrInd[0]];
	  
	  //For each row of the partition mat list
	  for(int j = 0; j < quickStore.size(); j++){
	    
	    //Obtain current row of the partitionMatList
	    IntegerVector aCurrRow = quickStore(j);
	    
	    //Clone the current connected component
	    IntegerVector toAdd = clone(myConnComp);
	    
	    //For transforming unique elements of the row
	    int addExtra = 1;
	    
	    //Obtain unique elements of the row
	    IntegerVector unqro = sort_unique(aCurrRow);

	    //Replace elements of unqrow based on how they fit into the partition
	    for(int k = 0; k < unqro.size(); k++){
	     
	      //Ones correspond to the original partition
	      if(unqro[k] == 1){
		unqro[k] = referConnComp[uniqCorrInd[0]];
	      }
	      
	      //Otherwise, replace unique entry with myNumConnComp + addExtra
	      else{
		
		unqro[k] = myNumConnComps + addExtra;
		addExtra++;
		
	      }
	    }

	    //Replace elements in myConnComp based on transformation in unqro
	    //Obtain the connected component associated with uniqCorrInd[0]
	    IntegerVector anoConnComp = listConnComps[referAdjList[uniqCorrInd[0]]];

	    for(int k = 0; k < anoConnComp.size(); k++){
	      
	      toAdd[anoConnComp[k]-1] = unqro[aCurrRow[k]-1];
	    }

	    //Add toAdd to tempGenParts
	    tempGenParts.push_back(toAdd);
	    
	  }
	}
	
	//Do similar stuff if sum isNonZero is greater than 1
	if(sum(isNonZero) > 1){
	  
	  //Store this sum
	  int totNonZero = sum(isNonZero);
	  
	  //First step, get an expanded grid
	  //Find the number of rows for each corresponding partition mat list
	  
	  IntegerVector nRowsPartMat(totNonZero);
	  
	  for(int k = 0; k < totNonZero; k++){
	    
	    //Store this guy quick
	    List quickStore = partitionMatList[uniqCorrInd[k]];

	    //Subtract 1 to match syntax of expandGrid
	    nRowsPartMat[k] = quickStore.size() - 1;
	  }

	  IntegerMatrix exGr = expandGrid(nRowsPartMat);
	  //printIntegerMatrix(exGr);
	  //Now we are ready to rock!
	  
	  //For each row of exGr
	  for(int k = 0; k < exGr.nrow(); k++){
	    
	    //Get the current row of the expanded grid
	    IntegerVector currExGr = exGr.row(k);
	    
	    //For transforming unique elements of the row
	    int addExtra = 1;
	    
	    //Clone the current connected component
	    IntegerVector toAdd = clone(myConnComp);	  
	    
	    //What's going on here?!?!?
	    //Cycle through all choices of row
	    for(int l = 0; l < currExGr.size(); l++){
	     
	      //Store this guy quick
	      List quickStore = partitionMatList[uniqCorrInd[l]];

	      //Obtain  current row of the mat list
	      IntegerVector aCurrRow = quickStore(currExGr[l]);
	      
	      //Obtain unique elements of the row
	      IntegerVector unqro = sort_unique(aCurrRow);
	      
	      //Replace elements of unqrow based on how they fit into the partition
	      for(int m = 0; m < unqro.size(); m++){
		
		//Ones correspond to the original partition
		if(unqro[m] == 1){
		  unqro[m] = referConnComp[uniqCorrInd[l]];
		}
	      
		//Otherwise, replace unique entry with myNumConnComp + addExtra
		else{

		  unqro[m] = myNumConnComps + addExtra;
		  addExtra++;
		  
		}
		
	      }

	      //Replace elements in myConnComp based on transformation in unqro
	      //Obtain the connected component associated with uniqCorrInd[0]
	      IntegerVector anoConnComp = listConnComps[referAdjList[uniqCorrInd[l]]];
	    
	      for(int m = 0; m < anoConnComp.size(); m++){
	      
		toAdd[anoConnComp[m]-1] = unqro[aCurrRow[m]-1];
	      }	      
	      
	    }
	    
	    //Add toAdd to tempGenParts
	    tempGenParts.push_back(toAdd);
	    
	  }
	} 
      }
    }
  }
  
  List getGeneratedPartition(){
    if(tempGenParts.size() == 0){
      return List(0);
    }
    else{
      return tempGenParts;
    }
  }

  bool canSplit(){
    return canExpand;
  }
  
  List getValidAllocs(){
    return validAllocs;
  }
  
 IntegerVector getNumPartConnComps(){
    return numPartConnComps;
  }
};

//Function to generate the partitions
//[[Rcpp::export]]
List cppGeneratePartitions(List adjList, int numBlocks, NumericVector popSizes, int numConstraintLow, int numConstraintHigh, double popConstraintLow, double popConstraintHigh){
  
  //Still need to do manipulations to ensure valid numbers.  But we can do that in R.
  
  //Store length of adjList
  //int adjListLength = adjList.size();

  //Initialize LIST that holds partitions:
  //HEY
  List partitionMatrix;
  
  //Initialize index for storing the partition
  int indexPartition = 0;

  //Initialize a logical vector to determine whether a span tree branch is valid. 
  LogicalVector vecIsValid; 

  //Intialize the spanning tree
  spanTree mySpanTree(adjList,popSizes);
  
  //Continue until the current span tree becomes too big.
  while(mySpanTree.getCurrDepth() < numConstraintHigh){
    // Rprintf("CurrDepth: %d\n",mySpanTree.getCurrDepth());
    //Check breaking the loop
    //If all candidate branches are removed, then no valid partition possible
    if((mySpanTree.getCurrDepth() > 0) && (mySpanTree.getCountCurrSpan() == 0)){
      break;
    }

    //Grow the spanning tree and get complement connected components
    // mySpanTree.printSpan();
    //Rcpp::Rcout <<"thengro:\n";
    mySpanTree.allGrow();
    //mySpanTree.printSpan();
    
    
    //Create a boolean for having fewer nodes than is permitted in the spanning tree
    bool fewerNodes = mySpanTree.getCurrDepth() < numConstraintLow;

    //FIRST CHECK: Fewer nodes than permitted in initial span tree and is not two connected
    //If so, can't remove nodes from the spanning tree, grow again:
    if(!fewerNodes || mySpanTree.get2con()){

      //Obtain the current number of rows in the spanning tree
      int numRows = mySpanTree.getCountCurrSpan();

      //Initialize vecIsValid logical vector
      vecIsValid = LogicalVector(numRows);

      //For each row in the spanning tree:
      for(int i = 0; i < numRows; i++){
	//printIntegerVector(mySpanTree.getConnComps(i));
	  
	//Get pop sums and number of nodes for each connected component:
	NumericVector popSums = mySpanTree.getConnCompPopSums(i);
	IntegerVector connCompLengths = mySpanTree.getCompConnCompLengths(i);
	
	//Create a variable for continuing on after these initial checks:
	bool carryOn = true;
        
	//Initialize vecIsValid[i] as true
	vecIsValid[i] = true;

	//SECOND CHECK: If the current branch has too many connected components
	//Or the sum of the current spanning tree branch is too big, 
	//Or the sum of any complement connected component is too small, 
	//Or if a connected component has too few nodes, find a new branch.
	//If the current spanning tree branch is too big OR if it has too many connected components and 2connectness holds...
	//mark the branch as invalid
	//otherwise, continue
	if((mySpanTree.getNumConnComps(i) > numBlocks) || 
	   (popSums[0] > popConstraintHigh) ||
	   (min(popSums[seq(1,mySpanTree.getNumConnComps(i) - 1)]) < popConstraintLow) ||
	   (min(connCompLengths[seq(0,mySpanTree.getNumConnComps(i) - 2)]) < numConstraintLow )){
	    
	  carryOn = false;

	  if(popSums[0] > popConstraintHigh|| mySpanTree.get2con()){	      
	    vecIsValid[i] = false;
	  }
	}


	//THIRD CHECK: If number of nodes too small, or pop sum is too small 
	//for the current branch of the spanning tree, choose another branch
	//and we carryOn
	if(!fewerNodes && popSums[0] >= popConstraintLow && carryOn){
	 
	  //At this point, each entry has at most numBlocks components
	  //And population sums are all greater than popConstraintLow
	  //And each block has at least numBlocks components	    

	  IntegerVector tempConnComp = mySpanTree.getConnComps(i);
	  
	  //printIntegerVector(tempConnComp);
	  
	  //If there are exactly numBlocks components 
	  if(mySpanTree.getNumConnComps(i) ==  numBlocks){

	    //If all population constraints fall within range, add the partition to the partition matrix: 
	    if(checkAllLeq(popSums,popConstraintHigh) && max(connCompLengths) <= numConstraintHigh ){
	      partitionMatrix.push_back(tempConnComp);

	      //Increment indexPartition
	      indexPartition++;
	    }
	  }

	  //Otherwise, there are less numBlocks components;
	  //We have to do some recursion!
	  else{
	    //We need the number of connected components
	    //int tempNumConnComps = mySpanTree.getNumConnComps();
	    //We need the connected components lengths
	    //IntegerVector tempCompLengths = mySpanTree.getCompConnCompLengths(i);
	    //Create a partition iterator object
	    partitionIterator myPartIt(adjList, numBlocks, popSizes, numConstraintLow, numConstraintHigh, tempConnComp, 
				       mySpanTree.getNumConnComps(i), connCompLengths);
	      
	    //FOURTH CHECK: If the complement components of the current branch of the spanning tree cannot be divided to make
	    //a valid partition, find a new branch
	    //if two connected, mark the branch as invalid
	    //otherwise, continue

	    if(!myPartIt.canSplit()){

	      if(mySpanTree.get2con()){
		vecIsValid[i] = false;
	      }	
	    }
	      
	    //Recursion is feasible.  Continue.
	    else{

	      //prepare Partitions through myPartIt
	      myPartIt.prepareNewPartitions();

	      //Generate partitions for each unique subgraph
	      //And put them into the myPartIt
	      for(int j = 0; j < myPartIt.getNumberIterations(); j++){

		myPartIt.storePartition(cppGeneratePartitions(myPartIt.getNewAdjList(j),myPartIt.getNewNumBlocks(j), 
							      myPartIt.getNewPopSizes(j), numConstraintLow, 
							      myPartIt.getNewNumConstraintHigh(j), popConstraintLow, popConstraintHigh));
	      }

		
	      //Work some magic inside the combinePartitions function
	      myPartIt.combinePartitions();		
	      

	      //Store results into a temporary IntegerMatrix
	      List tempList = myPartIt.getGeneratedPartition();
	     
	      //If the tempIntegerMatrix is non trivial...
	      if(tempList.size() != 0){
		  
		//Replace entries of partitionMatrix
		for(int j = 0; j < tempList.size(); j++){
		  
		  partitionMatrix.push_back(tempList(j));
		  
		  
		  //Increment indexPartition
		  indexPartition++;
		}
	      }
	    }
	  }
	}
      }
    
      // for(int b = 0; b < vecIsValid.size(); b++){
      // 	Rcpp::Rcout<< vecIsValid[b] << " ";
      // } 
      // Rcpp::Rcout << "\n";

      //Remove invalid rows  
      mySpanTree.removeSpanTree(vecIsValid);
      
    }	
    
  }
  
  //If no valid partition was produced:
  if(indexPartition == 0){
    
    //Return an integer matrix with one row, one column, with a zero
    return List(0);
  }
  
  //Otherwise, return the partition matrix
  else{

    return partitionMatrix;
  }
}
