plans <- plans_10[, 1:2]

test_that("compactness works", {
    capture.output(
        comp <- redist.compactness(
            shp = fl25, plans = plans,
            measure = "all", total_pop = pop, planarize = FALSE,
            counties = rep(1, 25)) %>% suppressWarnings()
    )
    expected <- structure(list(
        district = c(1L, 2L, 3L, 1L, 2L, 3L), PolsbyPopper = c(
            0.28097417163596,
            0.25130532031779, 0.32157642432607, 0.394022094408435, 0.25130532031779,
            0.223058240647906
        ), Schwartzberg = c(
            0.530069968622974, 0.501303620890364,
            0.567077088521543, 0.627711792472019, 0.501303620890364, 0.472290419813811
        ), LengthWidth = c(
            0.926285160038819, 0.653935724266415, 0.404149212048674,
            0.874431619447365, 0.653935724266415, 0.417276720351394
        ), ConvexHull = c(
            0.688881302064597,
            0.657235285584608, 0.696584187586064, 0.724528346382683, 0.657235285584608,
            0.598835368827732
        ), Reock = c(
            0.436913044036918, 0.308475061161299,
            0.226034757924429, 0.427167165858294, 0.308475061161299, 0.21214911798771
        ), BoyceClark = c(
            0.820211159002851, 0.761493024898368, 0.729357474768565,
            0.834576569326994, 0.761493024898368, 0.836077179813682
        ), FryerHolden = c(
            131124756.627412,
            131124756.627412, 131124756.627412, 105282505.012801, 105282505.012801,
            105282505.012801
        ), EdgesRemoved = c(16, 16, 16, 16, 16, 16),
        FracKept = c(
            0.843137254901961, 0.843137254901961, 0.843137254901961,
            0.843137254901961, 0.843137254901961, 0.843137254901961
        ),
        logSpanningTree = c(
            12.6907185515128, 12.6907185515128, 12.6907185515128,
            12.6907185515128, 12.6907185515128, 12.6907185515128
        ), draw = c(
            1,
            1, 1, 2, 2, 2
        )
    ), row.names = c(NA, -6L), class = c(
        "tbl_df",
        "tbl", "data.frame"
    ))

    expect_equal(comp, expected, tolerance = 1e-4)
})
