% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redist_findparams.R
\name{redist.findparams}
\alias{redist.findparams}
\title{Run parameter testing for \code{redist.flip}}
\usage{
redist.findparams(
  map,
  nsims,
  init_plan = NULL,
  adapt_lambda = FALSE,
  adapt_eprob = FALSE,
  params,
  ssdmat = NULL,
  group_pop = NULL,
  counties = NULL,
  nstartval_store = 1,
  maxdist_startval = 100,
  maxiterrsg = 5000,
  report_all = TRUE,
  parallel = FALSE,
  ncores = NULL,
  log = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{map}{A \code{\link{redist_map}} object.}

\item{nsims}{The number of simulations run before a save point.}

\item{init_plan}{A vector containing the congressional district labels
of each geographic unit. The default is \code{NULL}. If not provided, random
and contiguous congressional district assignments will be generated using \code{redist.rsg}.}

\item{adapt_lambda}{Whether to adaptively tune the lambda parameter so that the Metropolis-Hastings
acceptance probability falls between 20\% and 40\%. Default is FALSE.}

\item{adapt_eprob}{Whether to adaptively tune the edgecut probability parameter so that the
Metropolis-Hastings acceptance probability falls between 20\% and 40\%. Default is
FALSE.}

\item{params}{A matrix of parameter values to test, such as the output of
\code{expand.grid}. Parameters accepted for \code{params} include \code{eprob},
\code{lambda}, \code{pop_tol}, \code{beta}, and \code{constraint}.}

\item{ssdmat}{A matrix of squared distances between geographic
units. The default is \code{NULL}.}

\item{group_pop}{A vector of populations for some sub-group of
interest. The default is \code{NULL}.}

\item{counties}{A vector of county membership assignments. The default is \code{NULL}.}

\item{nstartval_store}{The number of maps to sample from the preprocessing chain
for use as starting values in future simulations. Default is 1.}

\item{maxdist_startval}{The maximum distance from the starting map that
sampled maps should be. Default is 100 (no restriction).}

\item{maxiterrsg}{Maximum number of iterations for random seed-and-grow
algorithm to generate starting values. Default is 5000.}

\item{report_all}{Whether to report all summary statistics for each set of
parameter values. Default is \code{TRUE}.}

\item{parallel}{Whether to run separate parameter settings in parallel.
Default is \code{FALSE}.}

\item{ncores}{Number of parallel tasks to run, declared outside of the
function. Default is \code{NULL}.}

\item{log}{Whether to open a log to track progress for each parameter combination
being tested. Default is FALSE.}

\item{verbose}{Whether to print additional information about the tests.
Default is \code{TRUE}.}
}
\value{
\code{redist.findparams} returns a print-out of summary statistics
about each parameter setting.
}
\description{
\code{redist.findparams} is used to find optimal parameter values of
\code{redist_flip} for a given map.
}
\details{
This function allows users to test multiple parameter settings of
\code{redist.flip} in preparation for a longer run for analysis.
}
\examples{
\donttest{
data(fl25)
data(fl25_enum)
data(fl25_adj)

## Get an initial partition
init_plan <- fl25_enum$plans[, 5118]

params <- expand.grid(eprob = c(.01, .05, .1))

# Make map
map_fl <- redist_map(fl25, ndists = 3, pop_tol = 0.2)
## Run the algorithm
redist.findparams(map_fl,
    init_plan = init_plan, nsims = 10000, params = params)
}
}
\references{
Fifield, Benjamin, Michael Higgins, Kosuke Imai and Alexander
Tarr. (2016) "A New Automated Redistricting Simulator Using Markov Chain Monte
Carlo." Working Paper. Available at
\url{http://imai.princeton.edu/research/files/redist.pdf}.
}
\concept{prepare}
