% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta.R
\name{beta}
\alias{beta}
\title{Standardized coeffients of a model.}
\usage{
beta(model, ...)
}
\arguments{
\item{model}{A fitted linear model of type 'lm', 'glm' or 'aov'.}

\item{...}{Additional arguments to be passed to the particular method for the
given model.}
}
\value{
The form of the value returned by \code{beta} depends on the class of
  its argument. See the documentation of the particular methods for details
  of what is produced by that method.
}
\description{
\code{beta} is a generic function for producing standardized coefficients
from regression models.
}
\examples{
# iris data
model1 <- lm(Sepal.Length ~ Petal.Length + Petal.Width, iris)
beta(model1)  # all three variables standardized

model2 <- lm(Sepal.Width ~ Petal.Width + Species, iris)
beta(model2, skip='Species')  # all variables except Species standardized
}
\seealso{
\code{\link{beta.lm}}, \code{\link{beta.glm}},
  \code{\link{beta.aov}}
}

