% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_model.R, R/build_model_doc.R
\name{summary.block_lm}
\alias{summary.block_lm}
\alias{print.block_lm_summary}
\alias{coef.block_lm}
\alias{residuals.block_lm}
\alias{fitted.block_lm}
\alias{summary.block_aov}
\alias{print.block_aov_summary}
\alias{coef.block_aov}
\alias{residuals.block_aov}
\alias{fitted.block_aov}
\alias{summary.block_glm}
\alias{print.block_glm_summary}
\alias{coef.block_glm}
\alias{residuals.block_glm}
\alias{fitted.block_glm}
\alias{block_model_summ}
\title{Summary functions for build_model block regression models.}
\usage{
\method{summary}{block_lm}(object, ...)

\method{print}{block_lm_summary}(x, digits = max(3L, getOption("digits") -
  3L), signif.stars = getOption("show.signif.stars"), ...)

\method{coef}{block_lm}(object, num = NULL, ...)

\method{residuals}{block_lm}(object, num = NULL, ...)

\method{fitted}{block_lm}(object, num = NULL, ...)

\method{summary}{block_aov}(object, ...)

\method{print}{block_aov_summary}(x, digits = max(3L, getOption("digits") -
  3L), signif.stars = getOption("show.signif.stars"), ...)

\method{coef}{block_aov}(object, num = NULL, ...)

\method{residuals}{block_aov}(object, num = NULL, ...)

\method{fitted}{block_aov}(object, num = NULL, ...)

\method{summary}{block_glm}(object, ...)

\method{print}{block_glm_summary}(x, digits = max(3L, getOption("digits") -
  3L), signif.stars = getOption("show.signif.stars"), ...)

\method{coef}{block_glm}(object, num = NULL, ...)

\method{residuals}{block_glm}(object, num = NULL, ...)

\method{fitted}{block_glm}(object, num = NULL, ...)
}
\arguments{
\item{object}{An object of class \code{block_lm}, \code{block_aov}, or
\code{block_glm}, usually, a result of a call to \code{\link{build_model}}.}

\item{...}{Further arguments passed to or from other methods.}

\item{x}{An object of class \code{block_lm_summary}, \code{block_aov_summary},
or \code{block_glm_summary}, usually, a result of a call to
the corresponding \code{summary} function (e.g., \code{summary.block_lm}).}

\item{digits}{The number of significant digits to use when printing.}

\item{signif.stars}{Logical. If \code{TRUE}, 'significance stars' are printed
for each coefficient.}

\item{num}{Numeric vector with the index of model(s) from which to return the
requested output. If NULL, will return output from all blocks.}
}
\value{
The \code{summary} function computes and returns a named list of
  summary statistics of the fitted linear models given in \code{object}. The
  list has the following elements:
\tabular{ll}{
  \code{formulas} \tab A list of the regression formulas used for each block.
  \cr
  \code{residuals} \tab A matrix with quantiles of the residuals for each
  model.\cr
  \code{coefficients} \tab A list with a matrix of coefficients for each
  model, as well as the standard error, t-statistic, and p-value.\cr
  \code{overall} \tab A data frame with information about the overall models,
  including the multiple R-squared value; adjusted R-squared; F-statistic,
  degrees of freedom, and p-value for each overall model; and the delta
  R-squared (change in R-squared) and its associated F-statistic and p-value.
  \cr
}
  The other functions listed here provide convenient access to the individual
  components of this summary.
}
\description{
These functions offer useful methods for objects created by the
\code{build_model} function: \code{block_lm}, \code{block_aov}, and
\code{block_glm}.
}
\examples{
# 2 blocks: Petal.Length; Petal.Length + Petal.Width
model1 <- build_model(Sepal.Length, Petal.Length, Petal.Width, data=iris, model='lm')
summary(model1)
coef(model1)  # returns coefficients from both blocks 1 and 2

# 2 blocks: Species; Species + Petal.Length + Petal.Width + Petal.Length:Petal.Width
model2 <- build_model(Sepal.Length, Species, c(Petal.Length * Petal.Width), data=iris, model='lm')
summary(model2)
coef(model2, num=2)  # returns coefficients from second block only
}
