% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factors.R
\name{rfactor}
\alias{rfactor}
\title{Draw random values from a factor variable}
\usage{
rfactor(n, levels, prob = rep_len(1/length(levels), length(levels)))
}
\arguments{
\item{n}{Number of values to draw}

\item{levels}{Character vector specifying the levels for the factor}

\item{prob}{Vector specifying the probability for each factor level}
}
\value{
Sample of \code{n} values from \code{levels}, drawn in proportion to their
probabilities. By default, levels are equally likely.
}
\description{
To specify the population distribution of a factor variable, specify the
probability for each of its factor levels. When drawn from the population,
factor levels are drawn with replacement according to their probability.
}
\examples{
rfactor(5, c("foo", "bar", "baz"), c(0.4, 0.3, 0.3))
}
\seealso{
\code{\link[=by_level]{by_level()}} to assign numeric values based on factor levels, such
as to set population regression coefficients by factor level
}
