% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny_tools.R
\name{tb_predic}
\alias{tb_predic}
\title{tb_predic}
\usage{
tb_predic(real, predic.var)
}
\arguments{
\item{real}{a data.frame with the real values.}

\item{predic.var}{a vector with the prediction value.}
}
\description{
creates comparison table between prediction and real data (test data).
}
\examples{
if(interactive()) {
  library(shiny)
  library(DT)
  shinyApp( 
    ui = fluidPage(fluidRow(column(12, DTOutput('tbl')))),
   server = function(input, output) {
     real <- iris[,'Petal.Width',drop = F]
     pred <- sample(iris$Petal.Width, nrow(iris), replace =  T)
     output$tbl = DT::renderDT(tb_predic(real, pred))
   })
}

}
