context('show_package_stats')

filename <- '/test_source_show_package_stats.R'
test_dir <- 'show_package_stats'
temp_dir <- tempdir()
testpath <- paste0(temp_dir, test_dir)
filepath <- paste0(testpath, filename)
dir.create(paste0(temp_dir, test_dir))

con <- file(filepath)
test_source <- 'library("dplyr")
# library(notused)
dplyr::filter()
require(dplyr)'
writeLines(text = test_source, con = con)
result <- show_package_stats(path = testpath)
close(con)


test_that('show_package_stats finds only used packages', {

  expect_true(any(result$package == 'dplyr'))
  expect_false(any(result$package == 'notused'))
})

test_that('show_package_stats finds the correct number of packages',
  expect_equal(result[result$package == 'dplyr', 'n'], 3)
)
