% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{randomREHsmall}
\alias{randomREHsmall}
\title{Random Relational Event History (small)}
\format{
\code{data(randomREHsmall)} will load a list containing following objects:
\describe{
   \item{\code{edgelist}}{a \code{data.frame} that contains the random sequence of events. Columns of the edgelist are:
           \describe{
               \item{\code{time}}{the timestamp indicating the time at which each event occurred;}
               \item{\code{actor1}}{the name of the actor that generated the relational event;}
               \item{\code{actor2}}{the name of the actor that received the relational event;}
           }
    }
   \item{\code{actors}}{names of actors interacting in the dynamic network.}
   \item{\code{origin}}{starting time point (\code{t_0}) prior to the first observed event (\code{t_1}), the class of this object must be the same as the one of the time column in the edgelist.}
   \item{\code{omit_dyad}}{a list where each element describes an alteration of the riskset which takes place at specific time points and for certain actors and/or types.
    }
}
}
\usage{
randomREHsmall
}
\description{
A subset from the randomly generated sequence of relational events `randomREH`, with 5 actors and 586 events (without event types).
}
\examples{
data(randomREHsmall)

# actors names
randomREHsmall$actors

# types names
randomREHsmall$types


# run the preprocessing function reh() by supplying the loaded objects.
small_edgelist_reh <- remify(edgelist = randomREHsmall$edgelist,
                    actors = randomREHsmall$actors,
                    directed = TRUE,
                    ordinal = FALSE,
                    origin = randomREHsmall$origin,
                    omit_dyad = randomREHsmall$omit_dyad,
                    model = "tie")

# `small_edgelist_reh` is an object of class `reh`
class(small_edgelist_reh)

# names of objects inside `small_edgelist_reh`
names(small_edgelist_reh)

}
\keyword{datasets}
