% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install-version.R
\name{download_version}
\alias{download_version}
\title{Download a specified version of a CRAN package}
\usage{
download_version(package, version = NULL, repos = getOption("repos"),
  type = getOption("pkgType"), ...)
}
\arguments{
\item{package}{package name}

\item{version}{If the specified version is NULL or the same as the most
recent version of the package, this function simply calls
\code{install.packages}. Otherwise, it looks at the list of
archived source tarballs and tries to install an older version instead.}

\item{repos}{
    character vector, the base URL(s) of the repositories
    to use, e.g., the URL of a CRAN mirror such as
    \code{"https://cloud.r-project.org"}.  For more details on
    supported URL schemes see \code{\link{url}}.

    Can be \code{NULL} to install from local files, directories or URLs:
    this will be inferred by extension from \code{pkgs} if of length one.
  }

\item{type}{character, indicating the type of package to download and
    install.  Will be \code{"source"} except on Windows and some macOS
    builds: see the section on \sQuote{Binary packages} for those.
  }

\item{...}{Other arguments passed on to \code{install.packages}.}
}
\value{
Name of the downloaded file.
}
\description{
It downloads the package to a temporary file, and
returns the name of the file.
}
