% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isolate.R
\name{isolate}
\alias{isolate}
\title{Isolate a Project}
\usage{
isolate(project = NULL)
}
\arguments{
\item{project}{The project directory. If \code{NULL}, then the active project will
be used. If no project is currently active, then the current working
directory is used instead.}
}
\value{
The project directory, invisibly. Note that this function is normally
called for its side effects.
}
\description{
Copy packages from the \code{renv} cache directly into the project library, so
that the project can continue to function independently of the \code{renv} cache.
}
\details{
After calling \code{isolate()}, \code{renv} will still be able to use the cache on
future \code{\link[=install]{install()}}s and \code{\link[=restore]{restore()}}s. If you'd prefer that \code{renv} copy
packages from the cache, rather than use symlinks, you can set the \code{renv}
configuration option:\preformatted{options(renv.config.cache.symlinks = FALSE)
}

to force \code{renv} to copy packages from the cache, as opposed to symlinking
them. If you'd like to disable the cache altogether for a project, you can
use:\preformatted{settings$use.cache(FALSE)
}

to explicitly disable the cache for the project.
}
\examples{
\dontrun{

# isolate a project
renv::isolate()

}
}
