% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repo_public.R
\name{repo_rm}
\alias{repo_rm}
\title{Remove item from the repo (and the disk).}
\usage{
repo_rm(name = NULL, tags = NULL, force = F)
}
\arguments{
\item{name}{An item's name.}

\item{tags}{A list of tags: all items matching the list will be
removed.}

\item{force}{Don't ask for confirmation.}
}
\value{
Used for side effects.
}
\description{
Remove item from the repo (and the disk).
}
\examples{
rp_path <- file.path(tempdir(), "example_repo")
rp <- repo_open(rp_path, TRUE)
rp$put(1, "item1", "Sample item 1", "info")
rp$put(2, "item2", "Sample item 2", "info")
print(rp)
rp$rm("item1")
print(rp)

## wiping temporary repo
unlink(rp_path, TRUE)
}
