% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NPSimulation.R
\name{calculateLargeSampleRandomizedDesignEffectSizes}
\alias{calculateLargeSampleRandomizedDesignEffectSizes}
\title{calculateLargeSampleRandomizedDesignEffectSizes}
\usage{
calculateLargeSampleRandomizedDesignEffectSizes(
  meanC = 0,
  sdC = 1,
  diff = 0,
  N = 5e+06,
  type = "n",
  StdAdj = 0
)
}
\arguments{
\item{meanC}{to act as the mean of the distribution (default 0) used to
generate the control group data (note for the gamma distribution this is the
rate parameter and must not be zero)}

\item{sdC}{the variance/spread of the distribution (default 1) used to generate the control group data.}

\item{diff}{a value (default 0) added to meanC to generate the treatment group data.}

\item{N}{the size of each group (default 5000000)}

\item{type}{the distribution of the data to be generated (default 'n')}

\item{StdAdj}{a value (default 0) that can be added to sdC to introduce heterogeneity into the tretament group}
}
\value{
A tibble identifying the sample statistics and the values of the probability of superiority, Cliff's d and StdMD (labelled StdES)
}
\description{
The function uses a simulates a large experiment  to estimate the asymptotic values of the probability of superiority, Cliff's d and the standardized mean difference data for a two group randomized experiment for four different distributions: Normal (i.e. type='n'), log-normal (i.e. type='l'), gama (i.e. tyep='g') and Laplace (i.e., type='lap').
}
\examples{
set.seed=400
calculateLargeSampleRandomizedDesignEffectSizes(
  meanC=0, sdC=1, diff=.5, N=100000, type='n',StdAdj = 0)
# A tibble: 1 x 9
#  MeanC   SdC MeanT   SdT  Phat Cliffd   UES   Var StdES
#  <dbl> <dbl> <dbl> <dbl> <dbl>  <dbl> <dbl> <dbl> <dbl>
#1     0     1   0.5     1 0.637  0.275 0.499  1.01 0.497

}
\author{
Barbara Kitchenham and Lech Madeyski
}
