% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache-helpers.R
\docType{methods}
\name{clearStubArtifacts}
\alias{clearStubArtifacts}
\alias{clearStubArtifacts,ANY-method}
\title{Clear erroneous archivist artifacts}
\usage{
clearStubArtifacts(repoDir = NULL)

\S4method{clearStubArtifacts}{ANY}(repoDir = NULL)
}
\arguments{
\item{repoDir}{A character denoting an existing directory of the repository for
which metadata will be returned. If \code{NULL} (default), it will use the
\code{repoDir} specified in \code{archivist::setLocalRepo}.}
}
\value{
Invoked for its side effect on the \code{repoDir}.
}
\description{
Clear stub artifacts resulting when an archive object is being saved at the
same time as another process doing the same thing.
}
\examples{
tmpDir <- file.path(tempdir(), "reproducible_examples", "clearStubArtifacts")

lapply(c(runif, rnorm), function(f) {
  reproducible::Cache(f, 10, cacheRepo = tmpDir)
})

# clear out any stub artifacts
clearStubArtifacts(tmpDir)

# cleanup
clearCache(tmpDir)
unlink(tmpDir, recursive = TRUE)

}
\author{
Eliot McIntire
}
