% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache-helpers.R
\docType{methods}
\name{.addChangedAttr}
\alias{.addChangedAttr}
\alias{.addChangedAttr,ANY-method}
\title{Add an attribute to an object indicating which named elements change}
\usage{
.addChangedAttr(object, preDigest, origArguments, ...)

\S4method{.addChangedAttr}{ANY}(object, preDigest, origArguments, ...)
}
\arguments{
\item{object}{Any R object returned from a function}

\item{preDigest}{The full, element by element hash of the input arguments to that same function,
e.g., from \code{.robustDigest}}

\item{origArguments}{These are the actual arguments (i.e., the values, not the names) that
were the source for \code{preDigest}}

\item{...}{Anything passed to methods.}
}
\value{
The object, modified
}
\description{
This is a generic definition that can be extended according to class.
}
\examples{
a <- 1
.addChangedAttr(a) # does nothing because default method is just a pass through
}
\author{
Eliot McIntire
}
