% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resmush_dir.R
\name{resmush_dir}
\alias{resmush_dir}
\title{Optimize files of several directories}
\usage{
resmush_dir(
  dir,
  ext = "\\\\.(png|jpe?g|bmp|gif|tif|webp)$",
  suffix = "_resmush",
  overwrite = FALSE,
  progress = TRUE,
  report = TRUE,
  recursive = FALSE,
  ...
)
}
\arguments{
\item{dir}{Character or vector of characters representing paths of local
directories.}

\item{ext}{\code{\link[base:regex]{regex}} indicating the extensions of the files to
be optimized. The default value would capture all the extensions admitted
by the API.}

\item{suffix}{Character, defaults to \code{"_resmush"}. By default, a new file
with the suffix is created in the same directory (i.e.,
optimized \code{example.png} would be \code{example_resmush.png}). Values \code{""}, \code{NA}
and \code{NULL} would be the same than \code{overwrite = TRUE}.}

\item{overwrite}{Logical. Should the files in \code{dir} be overwritten? If \code{TRUE}
\code{suffix} would be ignored.}

\item{progress}{Logical. Display a progress bar when needed.}

\item{report}{Logical. Display a summary report of the process in the
console. See also \strong{Value}.}

\item{recursive}{Logical. Should the \code{dir} file search recursive? See also
\code{\link[=list.files]{list.files()}}.}

\item{...}{
  Arguments passed on to \code{\link[=resmush_file]{resmush_file}}
  \describe{
    \item{\code{qlty}}{Only affects \code{jpg} files. Integer between 0 and 100 indicating
the optimization level. For optimal results use vales above 90.}
    \item{\code{exif_preserve}}{Logical. Should the
\href{https://en.wikipedia.org/wiki/Exif}{Exif} information (if any) deleted?
Default is to remove it (i.e. \code{exif_preserve = FALSE}).}
  }}
}
\value{
Writes on disk the optimized file if the API call is successful in the
directories specified in \code{dir}.

In all cases, a (invisible) data frame with a summary of the process is
returned as well.
}
\description{
Optimize all the local files of a directory (or list of directories) using
the  \href{https://resmush.it/}{reSmush.it API}.
}
\examples{
\dontshow{if (curl::has_internet()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
# Get example dir and copy
example_dir <- system.file("extimg", package = "resmush")
temp_dir <- tempdir()
file.copy(example_dir, temp_dir, recursive = TRUE)

# Dest folder

dest_folder <- file.path(tempdir(), "extimg")


# Non-recursive
resmush_dir(dest_folder)
resmush_clean_dir(dest_folder)

# Recursive
summary <- resmush_dir(dest_folder, recursive = TRUE)

# Same info in the invisible df
summary[, -c(1, 2)]

# Display with png
if (require("png", quietly = TRUE)) {
  a_png <- grepl("png$", summary$dest_img)
  my_png <- png::readPNG(summary[a_png, ]$dest_img[2])
  grid::grid.raster(my_png)
}

# Clean up example
unlink(dest_folder, force = TRUE, recursive = TRUE)
}
\dontshow{\}) # examplesIf}
}
\seealso{
\href{https://resmush.it/api/}{reSmush.it API} docs.

See \code{\link[=resmush_clean_dir]{resmush_clean_dir()}} to clean a directory of previous runs.

Other functions for optimizing:
\code{\link{resmush_file}()},
\code{\link{resmush_url}()}
}
\concept{optimize}
