% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_data.R
\name{extract_data}
\alias{extract_data}
\title{Extract data values from SDMX XML}
\usage{
extract_data(xml_lf, keep_flags = FALSE, stringsAsFactors = FALSE, bulk = TRUE)
}
\arguments{
\item{xml_lf}{an input XML leaf with data series from an SDMX XML file to extract the value and its dimensions from it}

\item{keep_flags}{a logical value if to extract the observation status (flag) information from the XML file. The default value is \code{FALSE}}

\item{stringsAsFactors}{a logical value. If \code{TRUE} the columns are converted to factors. The default is \code{FALSE}, 
in this case the strings are returned as characters.}

\item{bulk}{a logical value with default value \code{TRUE} if the input SDMX XML file is from the bulk download facility containing all the observations. 
If the input file has pre-filtered values then the value \code{FALSE} should be used.}
}
\value{
a data frame containing the values of an SDMX node: the dimensions, value and the optional flag(s)
}
\description{
Extracts the data values from the SDMX XML data file
}
\details{
It is a sub-function to use in the \code{\link{get_eurostat_data}} and the \code{\link{get_eurostat_raw}} functions.
}
\examples{
\dontshow{
if (parallel::detectCores()<=2){
   options(restatapi_cores=1)
}else{
   options(restatapi_cores=2)
}
}
\donttest{
id<-"agr_r_milkpr"
toc<-get_eurostat_toc()
bulk_url<-toc$downloadLink.sdmx[toc$code==id]
options(timeout=2)
if (!is.null(bulk_url)){
  temp<-tempfile()
  download.file(bulk_url,temp)
  sdmx_xml<-xml2::read_xml(unzip(temp,paste0(id,".sdmx.xml"),exdir=tempdir()))
  xml_leafs<-xml2::xml_find_all(sdmx_xml,".//data:Series")
  extract_data(xml_leafs[1])
  unlink(temp)
  unlink(file.path(tempdir(),paste0(id,".sdmx.xml")))
}
options(timeout=60)
}

}
