% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/status-tools.R
\name{restez_status}
\alias{restez_status}
\title{Check restez status}
\usage{
restez_status(gb_check = FALSE)
}
\arguments{
\item{gb_check}{Check whether last download was from latest GenBank release?
Default FALSE.}
}
\value{
Status class
}
\description{
Report to console current setup status of restez.
}
\details{
Always remember to run \code{\link{restez_connect}} before running
this function. Set gb_check=TRUE to see if your downloads are up-to-date.
}
\examples{
library(restez)
fp <- tempdir()
restez_path_set(filepath = fp)
demo_db_create(n = 5)
restez_connect()
restez_status()
restez_disconnect()
db_delete(everything = TRUE)
# Errors:
# restez_status()
}
\seealso{
Other setup: \code{\link{restez_connect}},
  \code{\link{restez_disconnect}},
  \code{\link{restez_path_get}},
  \code{\link{restez_path_set}},
  \code{\link{restez_path_unset}},
  \code{\link{restez_ready}}
}
\concept{setup}
