/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.objective;

import java.util.Objects;
import java.util.function.Function;
import org.chocosolver.solver.ResolutionPolicy;
import org.chocosolver.solver.objective.IObjectiveManager;
import org.chocosolver.solver.variables.Variable;

abstract class AbstractObjManager<V extends Variable>
implements IObjectiveManager<V> {
    private static final long serialVersionUID = 4330218142281861652L;
    protected final transient V objective;
    protected final ResolutionPolicy policy;
    protected final Number precision;
    protected Number bestProvedLB;
    protected Number bestProvedUB;
    protected transient Function<Number, Number> cutComputer = n -> n;

    public AbstractObjManager(AbstractObjManager<V> objman) {
        this.objective = objman.objective;
        this.policy = objman.policy;
        this.precision = objman.precision;
        this.bestProvedLB = objman.bestProvedLB;
        this.bestProvedUB = objman.bestProvedUB;
        this.cutComputer = objman.cutComputer;
    }

    public AbstractObjManager(V objective, ResolutionPolicy policy, Number precision) {
        assert (Objects.nonNull(objective));
        this.objective = objective;
        assert (Objects.nonNull((Object)policy));
        this.policy = policy;
        assert (Objects.nonNull(precision));
        this.precision = precision;
    }

    @Override
    public final V getObjective() {
        return this.objective;
    }

    @Override
    public final ResolutionPolicy getPolicy() {
        return this.policy;
    }

    @Override
    public final Number getBestLB() {
        return this.bestProvedLB;
    }

    @Override
    public final Number getBestUB() {
        return this.bestProvedUB;
    }

    @Override
    public final void setCutComputer(Function<Number, Number> cutComputer) {
        this.cutComputer = cutComputer;
    }

    @Override
    public final void setWalkingDynamicCut() {
        this.cutComputer = obj -> obj;
    }
}

