/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy.decision;

import java.util.function.Consumer;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.learn.ExplanationForSignedClause;
import org.chocosolver.solver.search.strategy.assignments.DecisionOperator;
import org.chocosolver.solver.search.strategy.assignments.DecisionOperatorFactory;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.PoolManager;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableRangeSet;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableSetUtils;

public class IntDecision
extends Decision<IntVar> {
    private static final long serialVersionUID = 4319290465131546449L;
    private int value;
    private DecisionOperator<IntVar> assignment;
    private final transient PoolManager<IntDecision> poolManager;

    public IntDecision(PoolManager<IntDecision> poolManager) {
        super(2);
        this.poolManager = poolManager;
    }

    @Override
    public Integer getDecisionValue() {
        return this.value;
    }

    @Override
    public void apply() throws ContradictionException {
        if (this.branch == 1) {
            ((IntVar)this.var).getModel().getSolver().getEventObserver().pushDecisionLevel();
            this.assignment.apply((IntVar)this.var, this.value, this);
        } else if (this.branch == 2) {
            this.assignment.unapply((IntVar)this.var, this.value, this);
        }
    }

    public void set(IntVar v, int value, DecisionOperator<IntVar> assignment) {
        super.set(v);
        this.value = value;
        this.assignment = assignment;
    }

    @Override
    public void reverse() {
        this.assignment = this.assignment.opposite();
    }

    @Override
    public void free() {
        this.poolManager.returnE(this);
    }

    public IntDecision duplicate() {
        IntDecision d = this.poolManager.getE();
        if (d == null) {
            d = new IntDecision(this.poolManager);
        }
        d.set((IntVar)this.var, this.value, this.assignment);
        return d;
    }

    @Override
    public boolean isEquivalentTo(Decision dec) {
        if (dec instanceof IntDecision) {
            IntDecision id = (IntDecision)dec;
            return id.var == this.var && id.assignment == this.assignment && id.value == this.value && id.max_branching == this.max_branching && id.branch == this.branch;
        }
        return false;
    }

    public DecisionOperator<IntVar> getDecOp() {
        return this.assignment;
    }

    public IntDecision flip() {
        IntDecision d = this.poolManager.getE();
        if (d == null) {
            d = new IntDecision(this.poolManager);
        }
        int val = this.value;
        if (this.assignment == DecisionOperatorFactory.makeIntSplit()) {
            ++val;
        } else if (this.assignment == DecisionOperatorFactory.makeIntReverseSplit()) {
            --val;
        }
        d.set((IntVar)this.var, val, this.assignment.opposite());
        return d;
    }

    public String toString() {
        boolean nonrefuted;
        boolean bl = nonrefuted = this.branch < this.max_branching || this.max_branching == 1 && this.branch == this.max_branching;
        if (this.assignment.getClass().equals(DecisionOperatorFactory.makeIntEq().getClass())) {
            return String.format("d_%d: %s%s%d", this.getPosition(), ((IntVar)this.var).getName(), nonrefuted ? "=" : Character.valueOf('\\'), this.value);
        }
        if (this.assignment.getClass().equals(DecisionOperatorFactory.makeIntNeq().getClass())) {
            return String.format("d_%d: %s%s%d", this.getPosition(), ((IntVar)this.var).getName(), nonrefuted ? "\u2260" : Character.valueOf('='), this.value);
        }
        if (this.assignment.getClass().equals(DecisionOperatorFactory.makeIntSplit().getClass())) {
            return String.format("d_%d: %s%s%s%d,%d]", this.getPosition(), ((IntVar)this.var).getName(), "\u2208", Character.valueOf(nonrefuted ? (char)'[' : ']'), nonrefuted ? ((IntVar)this.var).getLB() : this.value, nonrefuted ? this.value : ((IntVar)this.var).getUB());
        }
        if (this.assignment.getClass().equals(DecisionOperatorFactory.makeIntReverseSplit().getClass())) {
            return String.format("d_%d: %s%s[%d,%d%s", this.getPosition(), ((IntVar)this.var).getName(), "\u2208", nonrefuted ? this.value : ((IntVar)this.var).getLB(), nonrefuted ? ((IntVar)this.var).getUB() : this.value, Character.valueOf(nonrefuted ? (char)']' : '['));
        }
        return String.format("d_%d: %s%s{%s}", this.getPosition(), ((IntVar)this.var).getName(), nonrefuted ? this.assignment.toString() : this.assignment.opposite().toString(), this.value);
    }

    @Override
    public void explain(int p, ExplanationForSignedClause explanation) {
        IntIterableRangeSet dom = explanation.complement((IntVar)this.var);
        IntIterableSetUtils.unionOf(dom, explanation.readDom(p));
        ((IntVar)this.var).intersectLit(dom, explanation);
    }

    @Override
    public void forEachIntVar(Consumer<IntVar> action) {
    }
}

