% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importance.R
\name{importance}
\alias{importance}
\alias{importance.rfPermute}
\alias{plotImportance}
\title{Extract rfPermute Importance Scores and p-values.}
\usage{
\method{importance}{rfPermute}(x, scale = TRUE, sort.by = NULL, decreasing = TRUE, ...)

plotImportance(
  x,
  plot.type = c("bar", "heatmap"),
  imp.type = NULL,
  scale = TRUE,
  sig.only = FALSE,
  alpha = 0.05,
  n = NULL,
  ranks = TRUE,
  xlab = NULL,
  ylab = NULL,
  main = NULL,
  size = 3,
  plot = TRUE
)
}
\arguments{
\item{x}{for \code{importance}, an object produced by a call to 
\code{rfPermute}. For \code{plotImportance}, either a \code{rfPermute} 
or \code{randomForest} model object. If the latter, it must have been 
run with \code{importance = TRUE}.}

\item{scale}{for permutation based measures, should the measures be divided 
their "standard errors"?}

\item{sort.by}{character vector giving the importance metric(s) or p-values 
to sort by. If \code{NULL}, defaults to \code{"MeanDecreaseAccuracy"} for 
classification models and \code{"\%IncMSE"} for regression models.}

\item{decreasing}{logical. Should the sort order be increasing or decreasing?}

\item{...}{arguments to be passed to and from other methods.}

\item{plot.type}{plot importances as a \code{bar} chart or \code{heatmap}?}

\item{imp.type}{character vector listing which importance measures to plot.
Can be class names (for classification models) or names of overall 
importance measures (e.g., "MeanDecreaseAccuracy").}

\item{sig.only}{Plot only the significant (<= \code{alpha}) predictors?}

\item{alpha}{a number specifying the critical alpha for identifying 
predictors with importance scores significantly different from random. 
This parameter is only relevant if \code{rf} is a \code{\link{rfPermute}}
object with p-values. Importance measures with p-values less than or 
equal to \code{alpha} will be denoted in barcharts in red and in the
heatmap by a white diamond. If set to \code{NULL}, significance is not 
denoted.}

\item{n}{plot \code{n} most important predictors.}

\item{ranks}{plot ranks instead of actual importance scores?}

\item{xlab, ylab}{labels for the x and y axes.}

\item{main}{main title for plot.}

\item{size}{a value specifying the size of the significance diamond in the 
heatmap if the p-value <= \code{alpha}.}

\item{plot}{display the plot?}
}
\description{
The \code{importance} function extracts a matrix of 
  the observed importance scores and p-values from the object 
  produced by a call to \code{rfPermute}. \code{plotImportance} produces 
  a visualization of importance scores as either a barchart or heatmap.
}
\examples{
data(mtcars)

# A classification model classifying cars to manual or automatic transmission 
am.rp <- rfPermute(factor(am) ~ ., mtcars, ntree = 100, nrep = 50)
  
imp.scaled <- importance(am.rp, scale = TRUE)
imp.scaled

# plot scaled importance scores
plotImportance(am.rp, scale = TRUE)

# plot unscaled and only significant scores
plotImportance(am.rp, scale = FALSE, sig.only = TRUE)

}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
