% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fkruskal_test.R
\name{f_kruskal_test}
\alias{f_kruskal_test}
\title{Perform multiple Kruskal-Wallis tests with a user-friendly output file, do data inspection and Dunn's test (of 'rstatix') as post hoc.}
\usage{
f_kruskal_test(
  formula,
  data = NULL,
  plot = TRUE,
  alpha = 0.05,
  output_type = "off",
  output_file = NULL,
  output_dir = NULL,
  save_in_wdir = FALSE,
  kruskal_assumptions_text = TRUE,
  adjust = "bonferroni",
  close_generated_files = FALSE,
  open_generated_files = TRUE
)
}
\arguments{
\item{formula}{A formula specifying the response and predictor variable (e.g., \code{response ~ predictor)}.
more response variables and predictors can be added using \code{-} or \code{+} (e.g., \code{response1 + response2 ~ predictor1 + predictor2)}. The function iterates through these combinations or response and predictors, because the Kruskal-Wallis test itself only allows one response and one predictor combination to be tested simultaneously.}

\item{data}{A \code{data.frame} containing the variables referenced in the formula.}

\item{plot}{Logical. If \code{TRUE}, generates plots (e.g., density plots and boxplots)
in the output files. Default is \code{TRUE}.}

\item{alpha}{Numeric. The significance level for the Kruskal-Wallis test and Dunn's
test. Default is  \code{0.05}.}

\item{output_type}{Character string. Specifies the output format: \code{"pdf"}, \code{"word"}, \code{"excel"}, \code{"rmd"}, \code{"off"} (no file generated) or \code{"console"}. The option \code{"console"} forces output to be printed. Default is \code{"off"}.}

\item{output_file}{Character string. The name of the output file (without extension).
If \code{NULL}, a default name is generated based on the dataset name. Default is \code{NULL}.}

\item{output_dir}{Character string specifying the name of the directory of the output file. Default is  \code{tempdir()}. If the \code{output_file} already contains a directory name \code{output_dir} can be omitted, if used it overwrites the dir specified in \code{output_file}.}

\item{save_in_wdir}{Logical. If \code{TRUE}, saves the file in the working directory Default is \code{FALSE}, to avoid unintended changes to the global environment. If the \code{output_dir} is specified \code{save_in_wdir} is overwritten with \code{output_dir}.}

\item{kruskal_assumptions_text}{Logical. If \code{TRUE}, includes a section about Kruskal-Wallis test assumptions in the output document. Default is \code{TRUE}.}

\item{adjust}{Character string. Adjustment method for pairwise comparisons in Dunn's test. Options include \code{"holm", "hommel", "bonferroni", "sidak", "hs", "hochberg", "bh", "by", "fdr"} or \code{"none"}. Default is \code{"bonferroni"}, if you don't want to adjust the p value (not recommended), use  \code{p.adjust.method = "none"}.}

\item{close_generated_files}{Logical. If \code{TRUE}, closes open 'Excel' or 'Word' files depending on the output format. This to be able to save the newly generated files. 'Pdf' files should also be closed before using the function and cannot be automatically closed. Default is \code{FALSE}.}

\item{open_generated_files}{Logical. If \code{TRUE}, opens the generated output files ('pdf', 'Word' or 'Excel') files depending on the output format. This to directly view the results after creation. Files are stored in tempdir(). Default is \code{TRUE}.}
}
\value{
An object of class 'f_kruskal_test' containing:
\itemize{
\item Kruskal-Wallis test results for each combination of response and predictor variables.
\item Dunn's test analysis results (if applicable).
\item Summary tables with compact letter displays for significant group differences.
}

Using the option \code{output_type}, it can also generate output in the form of: R Markdown code, 'Word', 'pdf', or 'Excel' files. Includes print and plot methods for 'f_kruskal_test' objects.
}
\description{
Performs the Kruskal-Wallis rank sum test to assess whether there are statistically significant differences between three or more independent groups. It provides detailed outputs, including plots, assumption checks, and post-hoc analyses using Dunn's test. Results can be saved in various formats ('pdf', 'Word', 'Excel', or console only) with customizable output options.
}
\details{
This function offers a comprehensive workflow for non-parametric analysis using the Kruskal-Wallis test:
\itemize{
\item Assumption Checks: Optionally includes a summary of assumptions in the output.
\item Visualization: Generates density plots and boxplots to visualize group distributions.
\item Post-hoc Analysis: Conducts Dunn's test with specified correction methods if significant differences are found.
}
-----------\cr

Output files are generated in the format specified by \code{output_type =} and saved to the working directory, options are \code{"pdf", "word"} or \code{"excel"}. If \code{output_type = "rmd"} is used it is adviced to use it in a chunk with \{r, echo=FALSE, results='asis'\}

This function requires [Pandoc](https://github.com/jgm/pandoc/releases/tag) (version 1.12.3 or higher), a universal document converter.
\itemize{
\item \bold{Windows:} Install Pandoc and ensure the installation folder \cr (e.g., "C:/Users/your_username/AppData/Local/Pandoc") is added to your system PATH.
\item \bold{macOS:} If using Homebrew, Pandoc is typically installed in "/usr/local/bin". Alternatively, download the .pkg installer and verify that the binary’s location is in your PATH.
\item \bold{Linux:} Install Pandoc through your distribution’s package manager (commonly installed in "/usr/bin" or "/usr/local/bin") or manually, and ensure the directory containing Pandoc is in your PATH.

\item If Pandoc is not found, this function may not work as intended.
}
}
\examples{
# Example usage:
data(iris)

# Perform Kruskal-Wallis test on Sepal.Length and Sepal.Width by Species
# with "holm" correction for posthoc dunn_test, without showing the output.
output <- f_kruskal_test(
               Sepal.Width + Sepal.Length ~ Species,
               data = iris,
               plot = FALSE,
               output_type = "word",
               adjust = "holm",
               open_generated_files = FALSE
               )

# Save Kruskal-Wallis test and posthoc to Excel sheets: Sepal.Width and Sepal.Length.
f_kruskal_out <- f_kruskal_test(
                     Sepal.Width + Sepal.Length ~ Species,
                     data = iris,
                     plot = FALSE,
                     output_type = "excel",
                     adjust = "holm",
                     open_generated_files = FALSE
                     )

}
\author{
Sander H. van Delden  \email{plantmind@proton.me} \cr
}
