% Generated by roxygen2 (4.0.0): do not edit by hand
\name{gs_content}
\alias{gs_content}
\title{Gets top content for a gauge, paginated.}
\usage{
gs_content(id, date = NULL, page = NULL, key = NULL,
  keyname = "GaugesKey", callopts = list())
}
\arguments{
  \item{callopts}{Curl debugging options passed in to
  httr::GET}

  \item{id}{Your gaug.es id}

  \item{date}{Date format YYYY-MM-DD.}

  \item{page}{page to return}

  \item{key}{API key. If left NULL, function looks for key
  in your options settings defined in the keyname
  parameter}

  \item{keyname}{Your API key name in your .Rprofile file}
}
\description{
Gets top content for a gauge, paginated.
}
\note{
Note that these examples only work if you provide your
		Gaug.es API key either by passing in the function, or
		storing your key in your .Rprofile file, defaults to looking
		for an entry of "GaugesKey".
}
\examples{
\dontrun{
# Default key name is GaugesKey
gs_content(id='4efd83a6f5a1f5158a000004')
gs_content(id='4efd83a6f5a1f5158a000004', date="2013-11-01")

# Get list of gauge's, then pass in one of the ids
out <- gs_gauge_list()
gs_content(id=out$brief[1,'id'])
}
}

